%--------------------------------------------------------------------------
% File     : PUZ033=Winds-1 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Puzzles
% Problem  : The Winds and the Windows Puzzle
% Version  : 
% English  : (1) There is always sunshine when the wind is in the
%                East.
%            (2) When it is cold and foggy, my neighbor practices the
%                flute.
%            (3) When my fire smokes, I set the door open.
%            (4) When it is cold and I feel rheumatic, I light my
%                fire.
%            (5) When the wind is in the East and comes in gusts, my
%                fire smokes.
%            (6) When I keep the door open, I am free from headache. (7) 
%            Even when the sun is shining and it is not cold, I
%                keep my window shut if it is foggy.
%            (8) When the wind does not come in gusts, and when I
%                have a fire and keep the door shut, I do not feel
%                rheumatic.
%            (9) Sunshine always brings on fog.
%            (10) When my neighbor practices the flute, I shut the
%                door, even if I have no headache.
%            (11) When there is a fog and the wind is in the East, I
%                feel rheumatic.
%            Show that when the wind is in the East, I keep my windows 
%            shut.

% Refs     : Carroll L. (1986), Lewis Carroll's Symbolic logic : part 
%            I, Elementary, part II, Advanced, C. N. Potter, New York, NY.
% Source   : [ANL]
% Names    : winds.ver1.in [ANL]

% Status   : 
% Syntax   : Number of clauses           :   13 (   2 non-Horn)(   2 unit)
%            Number of literals          :   32 (   0 equality)
%            Number of predicate symbols :   12 (  12 propositional)
%            Number of function symbols  :    0 (   0 constant)
%            Number of variables         :    0 (   0 singleton)
%            Maximal clause size         :    4
%            Maximal term depth          :    0

% Comments : 
%--------------------------------------------------------------------------
input_clause(c1,axiom,
    [--wind_in_east,++sunshine]).

input_clause(c2,axiom,
    [--cold,--foggy,++neighbor_practices_flute]).

input_clause(c3,axiom,
    [--fire_smokes,++door_is_open]).

input_clause(c4,axiom,
    [--cold,--i_feel_rheumatic,++fire_is_lit]).

input_clause(c5,axiom,
    [--wind_in_east,--wind_in_gusts,++fire_smokes]).

input_clause(c6,axiom,
    [--door_is_open,--headache]).

input_clause(c7,axiom,
    [--sunshine,++cold,--foggy,++window_is_shut]).

input_clause(c8,axiom,
    [++wind_in_gusts,--fire_is_lit,++door_is_open,--i_feel_rheumatic]).

input_clause(c9,axiom,
    [--sunshine,++foggy]).

input_clause(c10,axiom,
    [--neighbor_practices_flute,--door_is_open]).

input_clause(c11,axiom,
    [--foggy,--wind_in_east,++i_feel_rheumatic]).

input_clause(name,hypothesis,
    [++wind_in_east]).

input_clause(prove_window_is_shut,theorem,
    [--window_is_shut]).
%--------------------------------------------------------------------------
