%--------------------------------------------------------------------------
% File     : PUZ032=KKnave26-1 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Puzzles
% Problem  : Knights and Knaves #26
% Version  : 
% English  : On a certain island the inhabitants are partitioned into 
%            those who always tell the truth and those who always lie. 
%            I landed on the island and met three inhabitants 
%            A, B, and C. I asked A, 'Are you a truthteller or a liar?' 
%            He mumbled something which I couldn't make out. I asked 
%            B what A had said. B replied, 'A said he was a liar'. C then 
%            volunteered, 'Don't believe B, he's lying!' What can you tell 
%            about A, B, and C?

% Refs     : Smullyan R.M. (1978), What is the name of this book? :
%            The riddle of Dracula and other logical puzzles, 
%            Prentice-Hall, Englewood Cliffs, NJ.
%          : Lusk E. and Overbeek R. (1985), Non-Horn Problems, Journal 
%            of Automated Reasoning 1(2), 103-114.
% Source   : [Lusk & Overbeek, 1985]
% Names    : Problem 26 [Smullyan, 1978]
%          : The Truthtellers and the Liars [Lusk & Overbeek, 1985]
%          : tandl.ver1.in [ANL]

% Status   : 
% Syntax   : Number of clauses           :   10 (   2 non-Horn)(   4 unit)
%            Number of literals          :   20 (   0 equality)
%            Number of predicate symbols :    1 (   0 propositional)
%            Number of function symbols  :    7 (   4 constant)
%            Number of variables         :   10 (   0 singleton)
%            Maximal clause size         :    3
%            Maximal term depth          :    4

% Comments : 
%--------------------------------------------------------------------------
%----Include axioms for truthtellers and liars 
include('Axioms/PUZ002-0.ax').
%--------------------------------------------------------------------------
input_clause(a_mumbles,hypothesis,
    [++a_truth(says(a,mumble))]).

input_clause(b_says_a_says_hes_a_liar,hypothesis,
    [++a_truth(says(b,says(a,liar(a))))]).

input_clause(c_says_b_is_a_liar,hypothesis,
    [++a_truth(says(c,liar(b)))]).

input_clause(prove_c_is_a_truthteller,theorem,
    [--a_truth(truthteller(c))]).
%--------------------------------------------------------------------------
