%--------------------------------------------------------------------------
% File     : PUZ030=SaltM-1 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Puzzles
% Problem  : Salt and Mustard Problem
% Version  : Theorem formulation : 1st order.
% English  : 

% Refs     : Lusk E. and Overbeek R. (1985), Non-Horn Problems, Journal 
%            of Automated Reasoning 1(2), 103-114.
%          : Carroll L. (1986), Lewis Carroll's Symbolic logic : part 
%            I, Elementary, part II, Advanced, C. N. Potter, New York, NY.
%          : Manthey R., Bry F. (1988), SATCHMO: a theorem prover 
%            implemented in Prolog, In Lusk E., Overbeek R. (Eds), 
%            Proceedings of the 9th International Conference on Automated 
%            Deduction (Argonne, IL, 1988), (Lecture Notes in Computer 
%            Science 310), Springer-Verlag, New York, NY, 415-434.
% Source   : [Lusk & Overbeek, 1985]
% Names    : Salt and Mustard Problem [Lusk & Overbeek, 1985]
%          : Salt-and-Mustard Problem [Manthey & Bry, 1988]

% Status   : 
% Syntax   : Number of clauses           :   43 (  13 non-Horn)(   0 unit)
%            Number of literals          :  106 (   0 equality)
%            Number of predicate symbols :    5 (   0 propositional)
%            Number of function symbols  :    5 (   5 constant)
%            Number of variables         :   12 (   0 singleton)
%            Maximal clause size         :    7
%            Maximal term depth          :    1

% Comments : 
%--------------------------------------------------------------------------
input_clause(both1,axiom,
    [--both(X),
     ++salt(X)]).

input_clause(both2,axiom,
    [--both(X),
     ++mustard(X)]).

input_clause(both3,axiom,
    [--salt(X),
     --mustard(X),
     ++both(X)]).

input_clause(oneof1,axiom,
    [--oneof(X),
     ++salt(X),
     ++mustard(X)]).

input_clause(oneof2,axiom,
    [--oneof(X),
     --both(X)]).

input_clause(oneof3,axiom,
    [--oneof(X),
     --neither(X)]).

input_clause(one_condition_holds1,axiom,
    [++both(X),
     ++neither(X),
     ++oneof(X)]).

input_clause(oneof4,axiom,
    [--oneof(X),
     --salt(X),
     --mustard(X)]).

input_clause(neither1,axiom,
    [--both(X),
     --neither(X)]).

input_clause(neither2,axiom,
    [--neither(X),
     --salt(X)]).

input_clause(neither3,axiom,
    [--neither(X),
     --mustard(X)]).

input_clause(neither4,axiom,
    [++salt(X),
     ++mustard(X),
     ++neither(X)]).

input_clause(rule1_1,hypothesis,
    [--salt(barry),
     ++oneof(cole),
     ++oneof(lang)]).

input_clause(rule1_2,hypothesis,
    [--oneof(cole),
     ++salt(barry)]).

input_clause(rule1_3,hypothesis,
    [--oneof(lang),
     ++salt(barry)]).

input_clause(rule2_1,hypothesis,
    [--mustard(barry),
     ++neither(dix),
     ++both(mill)]).

input_clause(rule2_2,hypothesis,
    [--neither(dix),
     ++mustard(barry)]).

input_clause(rule2_3,hypothesis,
    [--both(mill),
     ++mustard(barry)]).

input_clause(rule3_1,hypothesis,
    [--salt(cole),
     ++oneof(barry),
     ++neither(mill)]).

input_clause(rule3_2,hypothesis,
    [--oneof(barry),
     ++salt(cole)]).

input_clause(rule3_3,hypothesis,
    [--neither(mill),
     ++salt(cole)]).

input_clause(rule4_1,hypothesis,
    [--mustard(cole),
     ++both(dix),
     ++both(lang)]).

input_clause(rule4_2,hypothesis,
    [--both(dix),
     ++mustard(cole)]).

input_clause(rule4_3,hypothesis,
    [--both(lang),
     ++mustard(cole)]).

input_clause(rule5_1,hypothesis,
    [--salt(dix),
     ++neither(barry),
     ++both(cole)]).

input_clause(rule5_2,hypothesis,
    [--neither(barry),
     ++salt(dix)]).

input_clause(rule5_3,hypothesis,
    [--both(cole),
     ++salt(dix)]).

input_clause(rule6_1,hypothesis,
    [--mustard(dix),
     ++neither(lang),
     ++neither(mill)]).

input_clause(rule6_2,hypothesis,
    [--neither(lang),
     ++mustard(dix)]).

input_clause(rule6_3,hypothesis,
    [--neither(mill),
     ++mustard(dix)]).

input_clause(rule7_1,hypothesis,
    [--salt(lang),
     ++oneof(barry),
     ++oneof(dix)]).

input_clause(rule7_2,hypothesis,
    [--oneof(barry),
     ++salt(lang)]).

input_clause(rule7_3,hypothesis,
    [--oneof(dix),
     ++salt(lang)]).

input_clause(rule8_1,hypothesis,
    [--mustard(lang),
     ++neither(cole),
     ++neither(mill)]).

input_clause(rule8_2,hypothesis,
    [--neither(cole),
     ++mustard(lang)]).

input_clause(rule8_3,hypothesis,
    [--neither(mill),
     ++mustard(lang)]).

input_clause(rule9_1,hypothesis,
    [--salt(mill),
     ++both(barry),
     ++both(lang)]).

input_clause(rule9_2,hypothesis,
    [--both(barry),
     ++salt(mill)]).

input_clause(rule9_3,hypothesis,
    [--both(lang),
     ++mustard(mill)]).

input_clause(rule10_1,hypothesis,
    [--mustard(mill),
     ++oneof(cole),
     ++oneof(dix)]).

input_clause(rule10_2,hypothesis,
    [--oneof(cole),
     ++mustard(mill)]).

input_clause(rule10_3,hypothesis,
    [--oneof(dix),
     ++mustard(mill)]).

input_clause(prove_who_takes_what,theorem,
    [--neither(cole),
     --neither(dix),
     --both(barry),
     --oneof(lang),
     --salt(mill),
     --mustard(lang),
     --oneof(mill)]).
%--------------------------------------------------------------------------
