%--------------------------------------------------------------------------
% File     : PUZ029=Pigs-1 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Puzzles
% Problem  : The pigs and balloons puzzle
% Version  : 
% English  : 1) All, who neither dance on tight ropes nor eat
%               penny-buns, are old.
%            2) Pigs, that are liable to giddiness, are treated with
%               respect.
%            3) A wise balloonist takes an umbrella with him.
%            4) No one ought to lunch in public who looks ridiculous
%               and eats penny-buns.
%            5) Young creatures, who go up in balloons, are liable to
%               giddiness.
%            6) Fat creatures, who look ridiculous, may lunch in
%               public, provided that they do not dance on tight
%               ropes.
%            7) No wise creatures dance on tight ropes, if liable to
%               giddiness.
%            8) A pig looks ridiculous, carrying an umbrella.
%            9) All, who do not dance on tight ropes, and who are
%               treated with respect are fat.
%            Show that no wise young pigs go up in balloons.

% Refs     : Carroll L. (1986), Lewis Carroll's Symbolic logic : part 
%            I, Elementary, part II, Advanced, C. N. Potter, New York, NY.
% Source   : [ANL]
% Names    : pigs.ver1.in [ANL]

% Status   : 
% Syntax   : Number of clauses           :   15 (   4 non-Horn)(   4 unit)
%            Number of literals          :   36 (   0 equality)
%            Number of predicate symbols :   13 (   0 propositional)
%            Number of function symbols  :    1 (   1 constant)
%            Number of variables         :   11 (   0 singleton)
%            Maximal clause size         :    4
%            Maximal term depth          :    1

% Comments : 
%--------------------------------------------------------------------------
input_clause(boring_old_people,axiom,
    [++dances_on_tightropes(X),
     ++eats_pennybuns(X),
     ++old(X)]).

input_clause(giddy_pigs_reated_with_respect,axiom,
    [--pig(X),
     --liable_to_giddiness(X),
     ++treated_with_respect(X)]).

input_clause(wise_ballonists_have_umbrellas,axiom,
    [--wise(X),
     --balloonist(X),
     ++has_umbrella(X)]).

input_clause(dont_look_ridiculous_eating_buns_in_public,axiom,
    [--looks_ridiculous(X),
     --eats_pennybuns(X),
     --eats_lunch_in_public(X)]).

input_clause(young_balloonists_get_giddy,axiom,
    [--balloonist(X),
     --young(X),
     ++liable_to_giddiness(X)]).

input_clause(fat_ridiculous_off_tightrope_eat_in_public,axiom,
    [--fat(X),
     --looks_ridiculous(X),
     ++dances_on_tightropes(X),
     ++eats_lunch_in_public(X)]).

input_clause(wise_giddy_dont_dance_on_tightrope,axiom,
    [--liable_to_giddiness(X),
     --wise(X),
     --dances_on_tightropes(X)]).

input_clause(pigs_look_ridiculous_with_umbrellas,axiom,
    [--pig(X),
     --has_umbrella(X),
     ++looks_ridiculous(X)]).

input_clause(non_dancers_who_are_respected_are_fat,axiom,
    [++dances_on_tightropes(X),
     --treated_with_respect(X),
     ++fat(X)]).

input_clause(young_or_old,axiom,
    [++young(X),
     ++old(X)]).

input_clause(not_young_and_old,axiom,
    [--young(X),
     --old(X)]).

input_clause(piggy_is_wise,hypothesis,
    [++wise(piggy)]).

input_clause(piggy_is_young,hypothesis,
    [++young(piggy)]).

input_clause(piggy_is_a_pig,hypothesis,
    [++pig(piggy)]).

input_clause(prove_piggy_is_no_balloonist,theorem,
    [++balloonist(piggy)]).
%--------------------------------------------------------------------------
