%--------------------------------------------------------------------------
% File     : PUZ028=Party-4 : TPTP v1.1.1. Bugfixed v1.1.0.
% Domain   : Puzzles
% Problem  : People at a party
% Version  : [SETHEO] axioms.
%            Theorem formulation : Grounded axioms and simplified.
% English  : We can always choose 3 persons who are either familiar
%            with each other or not familiar with each other, from 6
%            persons who meet at a party.

% Refs     : 
% Source   : [SETHEO]
% Names    : ramsey3a.lop [SETHEO]

% Status   : satisfiable
% Syntax   : Number of clauses           :  270 (  30 non-Horn)(   0 unit)
%            Number of literals          :  780 (   0 equality)
%            Number of predicate symbols :    2 (   0 propositional)
%            Number of function symbols  :    6 (   6 constant)
%            Number of variables         :    0 (   0 singleton)
%            Maximal clause size         :    3
%            Maximal term depth          :    1

% Comments : 
%--------------------------------------------------------------------------
%----    ++familiar(X,Y),
%----    ++not_familiar(X,Y),
%----All ground instances of the above clause:
%----X=1
%----Y=1-6
input_clause(familiar_or_not_1_2,axiom,
    [++familiar(1,2),
     ++not_familiar(1,2)]).

input_clause(familiar_or_not_1_3,axiom,
    [++familiar(1,3),
     ++not_familiar(1,3)]).

input_clause(familiar_or_not_1_4,axiom,
    [++familiar(1,4),
     ++not_familiar(1,4)]).

input_clause(familiar_or_not_1_5,axiom,
    [++familiar(1,5),
     ++not_familiar(1,5)]).

input_clause(familiar_or_not_1_6,axiom,
    [++familiar(1,6),
     ++not_familiar(1,6)]).

%----X=2
%----Y=1-6
input_clause(familiar_or_not_2_1,axiom,
    [++familiar(2,1),
     ++not_familiar(2,1)]).

input_clause(familiar_or_not_2_3,axiom,
    [++familiar(2,3),
     ++not_familiar(2,3)]).

input_clause(familiar_or_not_2_4,axiom,
    [++familiar(2,4),
     ++not_familiar(2,4)]).

input_clause(familiar_or_not_2_5,axiom,
    [++familiar(2,5),
     ++not_familiar(2,5)]).

input_clause(familiar_or_not_2_6,axiom,
    [++familiar(2,6),
     ++not_familiar(2,6)]).

%----X=3
%----Y=1-6
input_clause(familiar_or_not_3_1,axiom,
    [++familiar(3,1),
     ++not_familiar(3,1)]).

input_clause(familiar_or_not_3_2,axiom,
    [++familiar(3,2),
     ++not_familiar(3,2)]).

input_clause(familiar_or_not_3_4,axiom,
    [++familiar(3,4),
     ++not_familiar(3,4)]).

input_clause(familiar_or_not_3_5,axiom,
    [++familiar(3,5),
     ++not_familiar(3,5)]).

input_clause(familiar_or_not_3_6,axiom,
    [++familiar(3,6),
     ++not_familiar(3,6)]).

%----X=4
%----Y=1-6
input_clause(familiar_or_not_4_1,axiom,
    [++familiar(4,1),
     ++not_familiar(4,1)]).

input_clause(familiar_or_not_4_2,axiom,
    [++familiar(4,2),
     ++not_familiar(4,2)]).

input_clause(familiar_or_not_4_3,axiom,
    [++familiar(4,3),
     ++not_familiar(4,3)]).

input_clause(familiar_or_not_4_5,axiom,
    [++familiar(4,5),
     ++not_familiar(4,5)]).

input_clause(familiar_or_not_4_6,axiom,
    [++familiar(4,6),
     ++not_familiar(4,6)]).

%----X=5
%----Y=1-6
input_clause(familiar_or_not_5_1,axiom,
    [++familiar(5,1),
     ++not_familiar(5,1)]).

input_clause(familiar_or_not_5_2,axiom,
    [++familiar(5,2),
     ++not_familiar(5,2)]).

input_clause(familiar_or_not_5_3,axiom,
    [++familiar(5,3),
     ++not_familiar(5,3)]).

input_clause(familiar_or_not_5_4,axiom,
    [++familiar(5,4),
     ++not_familiar(5,4)]).

input_clause(familiar_or_not_5_6,axiom,
    [++familiar(5,6),
     ++not_familiar(5,6)]).

%----X=6
%----Y=1-6
input_clause(familiar_or_not_6_1,axiom,
    [++familiar(6,1),
     ++not_familiar(6,1)]).

input_clause(familiar_or_not_6_2,axiom,
    [++familiar(6,2),
     ++not_familiar(6,2)]).

input_clause(familiar_or_not_6_3,axiom,
    [++familiar(6,3),
     ++not_familiar(6,3)]).

input_clause(familiar_or_not_6_4,axiom,
    [++familiar(6,4),
     ++not_familiar(6,4)]).

input_clause(familiar_or_not_6_5,axiom,
    [++familiar(6,5),
     ++not_familiar(6,5)]).

%----       --familiar(X1,X2),
%----       --familiar(X2,X3),
%----       --familiar(X3,X1)]).
%----All ground instances of the above clause:
%----X=1
%----Y=1
%----Z=1-6
%----X=1
%----Y=2
%----Z=1-6
input_clause(three_familiar_1_2_3,theorem,
    [--familiar(1,2),
     --familiar(2,3),
     --familiar(3,1)]).

input_clause(three_familiar_1_2_4,theorem,
    [--familiar(1,2),
     --familiar(2,4),
     --familiar(4,1)]).

input_clause(three_familiar_1_2_5,theorem,
    [--familiar(1,2),
     --familiar(2,5),
     --familiar(5,1)]).

input_clause(three_familiar_1_2_6,theorem,
    [--familiar(1,2),
     --familiar(2,6),
     --familiar(6,1)]).

%----X=1
%----Y=3
%----Z=1-6
input_clause(three_familiar_1_3_2,theorem,
    [--familiar(1,3),
     --familiar(3,2),
     --familiar(2,1)]).

input_clause(three_familiar_1_3_4,theorem,
    [--familiar(1,3),
     --familiar(3,4),
     --familiar(4,1)]).

input_clause(three_familiar_1_3_5,theorem,
    [--familiar(1,3),
     --familiar(3,5),
     --familiar(5,1)]).

input_clause(three_familiar_1_3_6,theorem,
    [--familiar(1,3),
     --familiar(3,6),
     --familiar(6,1)]).

%----X=1
%----Y=4
%----Z=1-6
input_clause(three_familiar_1_4_2,theorem,
    [--familiar(1,4),
     --familiar(4,2),
     --familiar(2,1)]).

input_clause(three_familiar_1_4_3,theorem,
    [--familiar(1,4),
     --familiar(4,3),
     --familiar(3,1)]).

input_clause(three_familiar_1_4_5,theorem,
    [--familiar(1,4),
     --familiar(4,5),
     --familiar(5,1)]).

input_clause(three_familiar_1_4_6,theorem,
    [--familiar(1,4),
     --familiar(4,6),
     --familiar(6,1)]).

%----X=1
%----Y=5
%----Z=1-6
input_clause(three_familiar_1_5_2,theorem,
    [--familiar(1,5),
     --familiar(5,2),
     --familiar(2,1)]).

input_clause(three_familiar_1_5_3,theorem,
    [--familiar(1,5),
     --familiar(5,3),
     --familiar(3,1)]).

input_clause(three_familiar_1_5_4,theorem,
    [--familiar(1,5),
     --familiar(5,4),
     --familiar(4,1)]).

input_clause(three_familiar_1_5_6,theorem,
    [--familiar(1,5),
     --familiar(5,6),
     --familiar(6,1)]).

%----X=1
%----Y=6
%----Z=1-6
input_clause(three_familiar_1_6_2,theorem,
    [--familiar(1,6),
     --familiar(6,2),
     --familiar(2,1)]).

input_clause(three_familiar_1_6_3,theorem,
    [--familiar(1,6),
     --familiar(6,3),
     --familiar(3,1)]).

input_clause(three_familiar_1_6_4,theorem,
    [--familiar(1,6),
     --familiar(6,4),
     --familiar(4,1)]).

input_clause(three_familiar_1_6_5,theorem,
    [--familiar(1,6),
     --familiar(6,5),
     --familiar(5,1)]).

%----X=2
%----Y=1
%----Z=1-6
input_clause(three_familiar_2_1_3,theorem,
    [--familiar(2,1),
     --familiar(1,3),
     --familiar(3,2)]).

input_clause(three_familiar_2_1_4,theorem,
    [--familiar(2,1),
     --familiar(1,4),
     --familiar(4,2)]).

input_clause(three_familiar_2_1_5,theorem,
    [--familiar(2,1),
     --familiar(1,5),
     --familiar(5,2)]).

input_clause(three_familiar_2_1_6,theorem,
    [--familiar(2,1),
     --familiar(1,6),
     --familiar(6,2)]).

%----X=2
%----Y=2
%----Z=1-6
%----X=2
%----Y=3
%----Z=1-6
input_clause(three_familiar_2_3_1,theorem,
    [--familiar(2,3),
     --familiar(3,1),
     --familiar(1,2)]).

input_clause(three_familiar_2_3_4,theorem,
    [--familiar(2,3),
     --familiar(3,4),
     --familiar(4,2)]).

input_clause(three_familiar_2_3_5,theorem,
    [--familiar(2,3),
     --familiar(3,5),
     --familiar(5,2)]).

input_clause(three_familiar_2_3_6,theorem,
    [--familiar(2,3),
     --familiar(3,6),
     --familiar(6,2)]).

%----X=2
%----Y=4
%----Z=1-6
input_clause(three_familiar_2_4_1,theorem,
    [--familiar(2,4),
     --familiar(4,1),
     --familiar(1,2)]).

input_clause(three_familiar_2_4_3,theorem,
    [--familiar(2,4),
     --familiar(4,3),
     --familiar(3,2)]).

input_clause(three_familiar_2_4_5,theorem,
    [--familiar(2,4),
     --familiar(4,5),
     --familiar(5,2)]).

input_clause(three_familiar_2_4_6,theorem,
    [--familiar(2,4),
     --familiar(4,6),
     --familiar(6,2)]).

%----X=2
%----Y=5
%----Z=1-6
input_clause(three_familiar_2_5_1,theorem,
    [--familiar(2,5),
     --familiar(5,1),
     --familiar(1,2)]).

input_clause(three_familiar_2_5_3,theorem,
    [--familiar(2,5),
     --familiar(5,3),
     --familiar(3,2)]).

input_clause(three_familiar_2_5_4,theorem,
    [--familiar(2,5),
     --familiar(5,4),
     --familiar(4,2)]).

input_clause(three_familiar_2_5_6,theorem,
    [--familiar(2,5),
     --familiar(5,6),
     --familiar(6,2)]).

%----X=2
%----Y=6
%----Z=1-6
input_clause(three_familiar_2_6_1,theorem,
    [--familiar(2,6),
     --familiar(6,1),
     --familiar(1,2)]).

input_clause(three_familiar_2_6_3,theorem,
    [--familiar(2,6),
     --familiar(6,3),
     --familiar(3,2)]).

input_clause(three_familiar_2_6_4,theorem,
    [--familiar(2,6),
     --familiar(6,4),
     --familiar(4,2)]).

input_clause(three_familiar_2_6_5,theorem,
    [--familiar(2,6),
     --familiar(6,5),
     --familiar(5,2)]).

%----X=3
%----Y=1
%----Z=1-1
input_clause(three_familiar_3_1_2,theorem,
    [--familiar(3,1),
     --familiar(1,2),
     --familiar(2,3)]).

input_clause(three_familiar_3_1_4,theorem,
    [--familiar(3,1),
     --familiar(1,4),
     --familiar(4,3)]).

input_clause(three_familiar_3_1_5,theorem,
    [--familiar(3,1),
     --familiar(1,5),
     --familiar(5,3)]).

input_clause(three_familiar_3_1_6,theorem,
    [--familiar(3,1),
     --familiar(1,6),
     --familiar(6,3)]).

%----X=3
%----Y=2
%----Z=1-6
input_clause(three_familiar_3_2_1,theorem,
    [--familiar(3,2),
     --familiar(2,1),
     --familiar(1,3)]).

input_clause(three_familiar_3_2_4,theorem,
    [--familiar(3,2),
     --familiar(2,4),
     --familiar(4,3)]).

input_clause(three_familiar_3_2_5,theorem,
    [--familiar(3,2),
     --familiar(2,5),
     --familiar(5,3)]).

input_clause(three_familiar_3_2_6,theorem,
    [--familiar(3,2),
     --familiar(2,6),
     --familiar(6,3)]).

%----X=3
%----Y=3
%----Z=1-6
%----X=3
%----Y=4
%----Z=1-6
input_clause(three_familiar_3_4_1,theorem,
    [--familiar(3,4),
     --familiar(4,1),
     --familiar(1,3)]).

input_clause(three_familiar_3_4_2,theorem,
    [--familiar(3,4),
     --familiar(4,2),
     --familiar(2,3)]).

input_clause(three_familiar_3_4_5,theorem,
    [--familiar(3,4),
     --familiar(4,5),
     --familiar(5,3)]).

input_clause(three_familiar_3_4_6,theorem,
    [--familiar(3,4),
     --familiar(4,6),
     --familiar(6,3)]).

%----X=3
%----Y=5
%----Z=1-6
input_clause(three_familiar_3_5_1,theorem,
    [--familiar(3,5),
     --familiar(5,1),
     --familiar(1,3)]).

input_clause(three_familiar_3_5_2,theorem,
    [--familiar(3,5),
     --familiar(5,2),
     --familiar(2,3)]).

input_clause(three_familiar_3_5_4,theorem,
    [--familiar(3,5),
     --familiar(5,4),
     --familiar(4,3)]).

input_clause(three_familiar_3_5_6,theorem,
    [--familiar(3,5),
     --familiar(5,6),
     --familiar(6,3)]).

%----X=3
%----Y=6
%----Z=1-6
input_clause(three_familiar_3_6_1,theorem,
    [--familiar(3,6),
     --familiar(6,1),
     --familiar(1,3)]).

input_clause(three_familiar_3_6_2,theorem,
    [--familiar(3,6),
     --familiar(6,2),
     --familiar(2,3)]).

input_clause(three_familiar_3_6_4,theorem,
    [--familiar(3,6),
     --familiar(6,4),
     --familiar(4,3)]).

input_clause(three_familiar_3_6_5,theorem,
    [--familiar(3,6),
     --familiar(6,5),
     --familiar(5,3)]).

%----X=4
%----Y=1
%----Z=1-6
input_clause(three_familiar_4_1_2,theorem,
    [--familiar(4,1),
     --familiar(1,2),
     --familiar(2,4)]).

input_clause(three_familiar_4_1_3,theorem,
    [--familiar(4,1),
     --familiar(1,3),
     --familiar(3,4)]).

input_clause(three_familiar_4_1_5,theorem,
    [--familiar(4,1),
     --familiar(1,5),
     --familiar(5,4)]).

input_clause(three_familiar_4_1_6,theorem,
    [--familiar(4,1),
     --familiar(1,6),
     --familiar(6,4)]).

%----X=4
%----Y=2
%----Z=1-6
input_clause(three_familiar_4_2_1,theorem,
    [--familiar(4,2),
     --familiar(2,1),
     --familiar(1,4)]).

input_clause(three_familiar_4_2_3,theorem,
    [--familiar(4,2),
     --familiar(2,3),
     --familiar(3,4)]).

input_clause(three_familiar_4_2_5,theorem,
    [--familiar(4,2),
     --familiar(2,5),
     --familiar(5,4)]).

input_clause(three_familiar_4_2_6,theorem,
    [--familiar(4,2),
     --familiar(2,6),
     --familiar(6,4)]).

%----X=4
%----Y=3
%----Z=1-6
input_clause(three_familiar_4_3_1,theorem,
    [--familiar(4,3),
     --familiar(3,1),
     --familiar(1,4)]).

input_clause(three_familiar_4_3_2,theorem,
    [--familiar(4,3),
     --familiar(3,2),
     --familiar(2,4)]).

input_clause(three_familiar_4_3_5,theorem,
    [--familiar(4,3),
     --familiar(3,5),
     --familiar(5,4)]).

input_clause(three_familiar_4_3_6,theorem,
    [--familiar(4,3),
     --familiar(3,6),
     --familiar(6,4)]).

%----X=4
%----Y=4
%----Z=1-6
%----X=4
%----Y=5
%----Z=1-6
input_clause(three_familiar_4_5_1,theorem,
    [--familiar(4,5),
     --familiar(5,1),
     --familiar(1,4)]).

input_clause(three_familiar_4_5_2,theorem,
    [--familiar(4,5),
     --familiar(5,2),
     --familiar(2,4)]).

input_clause(three_familiar_4_5_3,theorem,
    [--familiar(4,5),
     --familiar(5,3),
     --familiar(3,4)]).

input_clause(three_familiar_4_5_6,theorem,
    [--familiar(4,5),
     --familiar(5,6),
     --familiar(6,4)]).

%----X=4
%----Y=6
%----Z=1-6
input_clause(three_familiar_4_6_1,theorem,
    [--familiar(4,6),
     --familiar(6,1),
     --familiar(1,4)]).

input_clause(three_familiar_4_6_2,theorem,
    [--familiar(4,6),
     --familiar(6,2),
     --familiar(2,4)]).

input_clause(three_familiar_4_6_3,theorem,
    [--familiar(4,6),
     --familiar(6,3),
     --familiar(3,4)]).

input_clause(three_familiar_4_6_5,theorem,
    [--familiar(4,6),
     --familiar(6,5),
     --familiar(5,4)]).

%----X=5
%----Y=1
%----Z=1-6
input_clause(three_familiar_5_1_2,theorem,
    [--familiar(5,1),
     --familiar(1,2),
     --familiar(2,5)]).

input_clause(three_familiar_5_1_3,theorem,
    [--familiar(5,1),
     --familiar(1,3),
     --familiar(3,5)]).

input_clause(three_familiar_5_1_4,theorem,
    [--familiar(5,1),
     --familiar(1,4),
     --familiar(4,5)]).

input_clause(three_familiar_5_1_6,theorem,
    [--familiar(5,1),
     --familiar(1,6),
     --familiar(6,5)]).

%----X=5
%----Y=2
%----Z=1-6
input_clause(three_familiar_5_2_1,theorem,
    [--familiar(5,2),
     --familiar(2,1),
     --familiar(1,5)]).

input_clause(three_familiar_5_2_3,theorem,
    [--familiar(5,2),
     --familiar(2,3),
     --familiar(3,5)]).

input_clause(three_familiar_5_2_4,theorem,
    [--familiar(5,2),
     --familiar(2,4),
     --familiar(4,5)]).

input_clause(three_familiar_5_2_6,theorem,
    [--familiar(5,2),
     --familiar(2,6),
     --familiar(6,5)]).

%----X=5
%----Y=3
%----Z=1-6
input_clause(three_familiar_5_3_1,theorem,
    [--familiar(5,3),
     --familiar(3,1),
     --familiar(1,5)]).

input_clause(three_familiar_5_3_2,theorem,
    [--familiar(5,3),
     --familiar(3,2),
     --familiar(2,5)]).

input_clause(three_familiar_5_3_4,theorem,
    [--familiar(5,3),
     --familiar(3,4),
     --familiar(4,5)]).

input_clause(three_familiar_5_3_6,theorem,
    [--familiar(5,3),
     --familiar(3,6),
     --familiar(6,5)]).

%----X=5
%----Y=4
%----Z=1-6
input_clause(three_familiar_5_4_1,theorem,
    [--familiar(5,4),
     --familiar(4,1),
     --familiar(1,5)]).

input_clause(three_familiar_5_4_2,theorem,
    [--familiar(5,4),
     --familiar(4,2),
     --familiar(2,5)]).

input_clause(three_familiar_5_4_3,theorem,
    [--familiar(5,4),
     --familiar(4,3),
     --familiar(3,5)]).

input_clause(three_familiar_5_4_6,theorem,
    [--familiar(5,4),
     --familiar(4,6),
     --familiar(6,5)]).

%----X=5
%----Y=5
%----Z=1-6
%----X=5
%----Y=6
%----Z=1-6
input_clause(three_familiar_5_6_1,theorem,
    [--familiar(5,6),
     --familiar(6,1),
     --familiar(1,5)]).

input_clause(three_familiar_5_6_2,theorem,
    [--familiar(5,6),
     --familiar(6,2),
     --familiar(2,5)]).

input_clause(three_familiar_5_6_3,theorem,
    [--familiar(5,6),
     --familiar(6,3),
     --familiar(3,5)]).

input_clause(three_familiar_5_6_4,theorem,
    [--familiar(5,6),
     --familiar(6,4),
     --familiar(4,5)]).

%----X=6
%----Y=1
%----Z=1-6
input_clause(three_familiar_6_1_2,theorem,
    [--familiar(6,1),
     --familiar(1,2),
     --familiar(2,6)]).

input_clause(three_familiar_6_1_3,theorem,
    [--familiar(6,1),
     --familiar(1,3),
     --familiar(3,6)]).

input_clause(three_familiar_6_1_4,theorem,
    [--familiar(6,1),
     --familiar(1,4),
     --familiar(4,6)]).

input_clause(three_familiar_6_1_5,theorem,
    [--familiar(6,1),
     --familiar(1,5),
     --familiar(5,6)]).

%----X=6
%----Y=2
%----Z=1-6
input_clause(three_familiar_6_2_1,theorem,
    [--familiar(6,2),
     --familiar(2,1),
     --familiar(1,6)]).

input_clause(three_familiar_6_2_3,theorem,
    [--familiar(6,2),
     --familiar(2,3),
     --familiar(3,6)]).

input_clause(three_familiar_6_2_4,theorem,
    [--familiar(6,2),
     --familiar(2,4),
     --familiar(4,6)]).

input_clause(three_familiar_6_2_5,theorem,
    [--familiar(6,2),
     --familiar(2,5),
     --familiar(5,6)]).

%----X=6
%----Y=3
%----Z=1-6
input_clause(three_familiar_6_3_1,theorem,
    [--familiar(6,3),
     --familiar(3,1),
     --familiar(1,6)]).

input_clause(three_familiar_6_3_2,theorem,
    [--familiar(6,3),
     --familiar(3,2),
     --familiar(2,6)]).

input_clause(three_familiar_6_3_4,theorem,
    [--familiar(6,3),
     --familiar(3,4),
     --familiar(4,6)]).

input_clause(three_familiar_6_3_5,theorem,
    [--familiar(6,3),
     --familiar(3,5),
     --familiar(5,6)]).

%----X=6
%----Y=4
%----Z=1-6
input_clause(three_familiar_6_4_1,theorem,
    [--familiar(6,4),
     --familiar(4,1),
     --familiar(1,6)]).

input_clause(three_familiar_6_4_2,theorem,
    [--familiar(6,4),
     --familiar(4,2),
     --familiar(2,6)]).

input_clause(three_familiar_6_4_3,theorem,
    [--familiar(6,4),
     --familiar(4,3),
     --familiar(3,6)]).

input_clause(three_familiar_6_4_5,theorem,
    [--familiar(6,4),
     --familiar(4,5),
     --familiar(5,6)]).

%----X=6
%----Y=5
%----Z=1-6
input_clause(three_familiar_6_5_1,theorem,
    [--familiar(6,5),
     --familiar(5,1),
     --familiar(1,6)]).

input_clause(three_familiar_6_5_2,theorem,
    [--familiar(6,5),
     --familiar(5,2),
     --familiar(2,6)]).

input_clause(three_familiar_6_5_3,theorem,
    [--familiar(6,5),
     --familiar(5,3),
     --familiar(3,6)]).

input_clause(three_familiar_6_5_4,theorem,
    [--familiar(6,5),
     --familiar(5,4),
     --familiar(4,6)]).

%----X=6
%----Y=6
%----Z=1-6
%----     --not_familiar(X1,X2),
%----     --not_familiar(X2,X3),
%----     --not_familiar(X3,X1)]).
%----All ground instances of the above clause:
%----X=1
%----Y=1
%----Z=1-6
%----X=1
%----Y=2
%----Z=1-6
input_clause(three_not_familiar_1_2_3,theorem,
    [--not_familiar(1,2),
     --not_familiar(2,3),
     --not_familiar(3,1)]).

input_clause(three_not_familiar_1_2_4,theorem,
    [--not_familiar(1,2),
     --not_familiar(2,4),
     --not_familiar(4,1)]).

input_clause(three_not_familiar_1_2_5,theorem,
    [--not_familiar(1,2),
     --not_familiar(2,5),
     --not_familiar(5,1)]).

input_clause(three_not_familiar_1_2_6,theorem,
    [--not_familiar(1,2),
     --not_familiar(2,6),
     --not_familiar(6,1)]).

%----X=1
%----Y=3
%----Z=1-6
input_clause(three_not_familiar_1_3_2,theorem,
    [--not_familiar(1,3),
     --not_familiar(3,2),
     --not_familiar(2,1)]).

input_clause(three_not_familiar_1_3_4,theorem,
    [--not_familiar(1,3),
     --not_familiar(3,4),
     --not_familiar(4,1)]).

input_clause(three_not_familiar_1_3_5,theorem,
    [--not_familiar(1,3),
     --not_familiar(3,5),
     --not_familiar(5,1)]).

input_clause(three_not_familiar_1_3_6,theorem,
    [--not_familiar(1,3),
     --not_familiar(3,6),
     --not_familiar(6,1)]).

%----X=1
%----Y=4
%----Z=1-6
input_clause(three_not_familiar_1_4_2,theorem,
    [--not_familiar(1,4),
     --not_familiar(4,2),
     --not_familiar(2,1)]).

input_clause(three_not_familiar_1_4_3,theorem,
    [--not_familiar(1,4),
     --not_familiar(4,3),
     --not_familiar(3,1)]).

input_clause(three_not_familiar_1_4_5,theorem,
    [--not_familiar(1,4),
     --not_familiar(4,5),
     --not_familiar(5,1)]).

input_clause(three_not_familiar_1_4_6,theorem,
    [--not_familiar(1,4),
     --not_familiar(4,6),
     --not_familiar(6,1)]).

%----X=1
%----Y=5
%----Z=1-6
input_clause(three_not_familiar_1_5_2,theorem,
    [--not_familiar(1,5),
     --not_familiar(5,2),
     --not_familiar(2,1)]).

input_clause(three_not_familiar_1_5_3,theorem,
    [--not_familiar(1,5),
     --not_familiar(5,3),
     --not_familiar(3,1)]).

input_clause(three_not_familiar_1_5_4,theorem,
    [--not_familiar(1,5),
     --not_familiar(5,4),
     --not_familiar(4,1)]).

input_clause(three_not_familiar_1_5_6,theorem,
    [--not_familiar(1,5),
     --not_familiar(5,6),
     --not_familiar(6,1)]).

%----X=1
%----Y=6
%----Z=1-6
input_clause(three_not_familiar_1_6_2,theorem,
    [--not_familiar(1,6),
     --not_familiar(6,2),
     --not_familiar(2,1)]).

input_clause(three_not_familiar_1_6_3,theorem,
    [--not_familiar(1,6),
     --not_familiar(6,3),
     --not_familiar(3,1)]).

input_clause(three_not_familiar_1_6_4,theorem,
    [--not_familiar(1,6),
     --not_familiar(6,4),
     --not_familiar(4,1)]).

input_clause(three_not_familiar_1_6_5,theorem,
    [--not_familiar(1,6),
     --not_familiar(6,5),
     --not_familiar(5,1)]).

%----X=2
%----Y=1
%----Z=1-6
input_clause(three_not_familiar_2_1_3,theorem,
    [--not_familiar(2,1),
     --not_familiar(1,3),
     --not_familiar(3,2)]).

input_clause(three_not_familiar_2_1_4,theorem,
    [--not_familiar(2,1),
     --not_familiar(1,4),
     --not_familiar(4,2)]).

input_clause(three_not_familiar_2_1_5,theorem,
    [--not_familiar(2,1),
     --not_familiar(1,5),
     --not_familiar(5,2)]).

input_clause(three_not_familiar_2_1_6,theorem,
    [--not_familiar(2,1),
     --not_familiar(1,6),
     --not_familiar(6,2)]).

%----X=2
%----Y=2
%----Z=1-6
%----X=2
%----Y=3
%----Z=1-6
input_clause(three_not_familiar_2_3_1,theorem,
    [--not_familiar(2,3),
     --not_familiar(3,1),
     --not_familiar(1,2)]).

input_clause(three_not_familiar_2_3_4,theorem,
    [--not_familiar(2,3),
     --not_familiar(3,4),
     --not_familiar(4,2)]).

input_clause(three_not_familiar_2_3_5,theorem,
    [--not_familiar(2,3),
     --not_familiar(3,5),
     --not_familiar(5,2)]).

input_clause(three_not_familiar_2_3_6,theorem,
    [--not_familiar(2,3),
     --not_familiar(3,6),
     --not_familiar(6,2)]).

%----X=2
%----Y=4
%----Z=1-6
input_clause(three_not_familiar_2_4_1,theorem,
    [--not_familiar(2,4),
     --not_familiar(4,1),
     --not_familiar(1,2)]).

input_clause(three_not_familiar_2_4_3,theorem,
    [--not_familiar(2,4),
     --not_familiar(4,3),
     --not_familiar(3,2)]).

input_clause(three_not_familiar_2_4_5,theorem,
    [--not_familiar(2,4),
     --not_familiar(4,5),
     --not_familiar(5,2)]).

input_clause(three_not_familiar_2_4_6,theorem,
    [--not_familiar(2,4),
     --not_familiar(4,6),
     --not_familiar(6,2)]).

%----X=2
%----Y=5
%----Z=1-6
input_clause(three_not_familiar_2_5_1,theorem,
    [--not_familiar(2,5),
     --not_familiar(5,1),
     --not_familiar(1,2)]).

input_clause(three_not_familiar_2_5_3,theorem,
    [--not_familiar(2,5),
     --not_familiar(5,3),
     --not_familiar(3,2)]).

input_clause(three_not_familiar_2_5_4,theorem,
    [--not_familiar(2,5),
     --not_familiar(5,4),
     --not_familiar(4,2)]).

input_clause(three_not_familiar_2_5_6,theorem,
    [--not_familiar(2,5),
     --not_familiar(5,6),
     --not_familiar(6,2)]).

%----X=2
%----Y=6
%----Z=1-6
input_clause(three_not_familiar_2_6_1,theorem,
    [--not_familiar(2,6),
     --not_familiar(6,1),
     --not_familiar(1,2)]).

input_clause(three_not_familiar_2_6_3,theorem,
    [--not_familiar(2,6),
     --not_familiar(6,3),
     --not_familiar(3,2)]).

input_clause(three_not_familiar_2_6_4,theorem,
    [--not_familiar(2,6),
     --not_familiar(6,4),
     --not_familiar(4,2)]).

input_clause(three_not_familiar_2_6_5,theorem,
    [--not_familiar(2,6),
     --not_familiar(6,5),
     --not_familiar(5,2)]).

%----X=3
%----Y=1
%----Z=1-1
input_clause(three_not_familiar_3_1_2,theorem,
    [--not_familiar(3,1),
     --not_familiar(1,2),
     --not_familiar(2,3)]).

input_clause(three_not_familiar_3_1_4,theorem,
    [--not_familiar(3,1),
     --not_familiar(1,4),
     --not_familiar(4,3)]).

input_clause(three_not_familiar_3_1_5,theorem,
    [--not_familiar(3,1),
     --not_familiar(1,5),
     --not_familiar(5,3)]).

input_clause(three_not_familiar_3_1_6,theorem,
    [--not_familiar(3,1),
     --not_familiar(1,6),
     --not_familiar(6,3)]).

%----X=3
%----Y=2
%----Z=1-6
input_clause(three_not_familiar_3_2_1,theorem,
    [--not_familiar(3,2),
     --not_familiar(2,1),
     --not_familiar(1,3)]).

input_clause(three_not_familiar_3_2_4,theorem,
    [--not_familiar(3,2),
     --not_familiar(2,4),
     --not_familiar(4,3)]).

input_clause(three_not_familiar_3_2_5,theorem,
    [--not_familiar(3,2),
     --not_familiar(2,5),
     --not_familiar(5,3)]).

input_clause(three_not_familiar_3_2_6,theorem,
    [--not_familiar(3,2),
     --not_familiar(2,6),
     --not_familiar(6,3)]).

%----X=3
%----Y=3
%----Z=1-6
%----X=3
%----Y=4
%----Z=1-6
input_clause(three_not_familiar_3_4_1,theorem,
    [--not_familiar(3,4),
     --not_familiar(4,1),
     --not_familiar(1,3)]).

input_clause(three_not_familiar_3_4_2,theorem,
    [--not_familiar(3,4),
     --not_familiar(4,2),
     --not_familiar(2,3)]).

input_clause(three_not_familiar_3_4_5,theorem,
    [--not_familiar(3,4),
     --not_familiar(4,5),
     --not_familiar(5,3)]).

input_clause(three_not_familiar_3_4_6,theorem,
    [--not_familiar(3,4),
     --not_familiar(4,6),
     --not_familiar(6,3)]).

%----X=3
%----Y=5
%----Z=1-6
input_clause(three_not_familiar_3_5_1,theorem,
    [--not_familiar(3,5),
     --not_familiar(5,1),
     --not_familiar(1,3)]).

input_clause(three_not_familiar_3_5_2,theorem,
    [--not_familiar(3,5),
     --not_familiar(5,2),
     --not_familiar(2,3)]).

input_clause(three_not_familiar_3_5_4,theorem,
    [--not_familiar(3,5),
     --not_familiar(5,4),
     --not_familiar(4,3)]).

input_clause(three_not_familiar_3_5_6,theorem,
    [--not_familiar(3,5),
     --not_familiar(5,6),
     --not_familiar(6,3)]).

%----X=3
%----Y=6
%----Z=1-6
input_clause(three_not_familiar_3_6_1,theorem,
    [--not_familiar(3,6),
     --not_familiar(6,1),
     --not_familiar(1,3)]).

input_clause(three_not_familiar_3_6_2,theorem,
    [--not_familiar(3,6),
     --not_familiar(6,2),
     --not_familiar(2,3)]).

input_clause(three_not_familiar_3_6_4,theorem,
    [--not_familiar(3,6),
     --not_familiar(6,4),
     --not_familiar(4,3)]).

input_clause(three_not_familiar_3_6_5,theorem,
    [--not_familiar(3,6),
     --not_familiar(6,5),
     --not_familiar(5,3)]).

%----X=4
%----Y=1
%----Z=1-6
input_clause(three_not_familiar_4_1_2,theorem,
    [--not_familiar(4,1),
     --not_familiar(1,2),
     --not_familiar(2,4)]).

input_clause(three_not_familiar_4_1_3,theorem,
    [--not_familiar(4,1),
     --not_familiar(1,3),
     --not_familiar(3,4)]).

input_clause(three_not_familiar_4_1_5,theorem,
    [--not_familiar(4,1),
     --not_familiar(1,5),
     --not_familiar(5,4)]).

input_clause(three_not_familiar_4_1_6,theorem,
    [--not_familiar(4,1),
     --not_familiar(1,6),
     --not_familiar(6,4)]).

%----X=4
%----Y=2
%----Z=1-6
input_clause(three_not_familiar_4_2_1,theorem,
    [--not_familiar(4,2),
     --not_familiar(2,1),
     --not_familiar(1,4)]).

input_clause(three_not_familiar_4_2_3,theorem,
    [--not_familiar(4,2),
     --not_familiar(2,3),
     --not_familiar(3,4)]).

input_clause(three_not_familiar_4_2_5,theorem,
    [--not_familiar(4,2),
     --not_familiar(2,5),
     --not_familiar(5,4)]).

input_clause(three_not_familiar_4_2_6,theorem,
    [--not_familiar(4,2),
     --not_familiar(2,6),
     --not_familiar(6,4)]).

%----X=4
%----Y=3
%----Z=1-6
input_clause(three_not_familiar_4_3_1,theorem,
    [--not_familiar(4,3),
     --not_familiar(3,1),
     --not_familiar(1,4)]).

input_clause(three_not_familiar_4_3_2,theorem,
    [--not_familiar(4,3),
     --not_familiar(3,2),
     --not_familiar(2,4)]).

input_clause(three_not_familiar_4_3_5,theorem,
    [--not_familiar(4,3),
     --not_familiar(3,5),
     --not_familiar(5,4)]).

input_clause(three_not_familiar_4_3_6,theorem,
    [--not_familiar(4,3),
     --not_familiar(3,6),
     --not_familiar(6,4)]).

%----X=4
%----Y=4
%----Z=1-6
%----X=4
%----Y=5
%----Z=1-6
input_clause(three_not_familiar_4_5_1,theorem,
    [--not_familiar(4,5),
     --not_familiar(5,1),
     --not_familiar(1,4)]).

input_clause(three_not_familiar_4_5_2,theorem,
    [--not_familiar(4,5),
     --not_familiar(5,2),
     --not_familiar(2,4)]).

input_clause(three_not_familiar_4_5_3,theorem,
    [--not_familiar(4,5),
     --not_familiar(5,3),
     --not_familiar(3,4)]).

input_clause(three_not_familiar_4_5_6,theorem,
    [--not_familiar(4,5),
     --not_familiar(5,6),
     --not_familiar(6,4)]).

%----X=4
%----Y=6
%----Z=1-6
input_clause(three_not_familiar_4_6_1,theorem,
    [--not_familiar(4,6),
     --not_familiar(6,1),
     --not_familiar(1,4)]).

input_clause(three_not_familiar_4_6_2,theorem,
    [--not_familiar(4,6),
     --not_familiar(6,2),
     --not_familiar(2,4)]).

input_clause(three_not_familiar_4_6_3,theorem,
    [--not_familiar(4,6),
     --not_familiar(6,3),
     --not_familiar(3,4)]).

input_clause(three_not_familiar_4_6_5,theorem,
    [--not_familiar(4,6),
     --not_familiar(6,5),
     --not_familiar(5,4)]).

%----X=5
%----Y=1
%----Z=1-6
input_clause(three_not_familiar_5_1_2,theorem,
    [--not_familiar(5,1),
     --not_familiar(1,2),
     --not_familiar(2,5)]).

input_clause(three_not_familiar_5_1_3,theorem,
    [--not_familiar(5,1),
     --not_familiar(1,3),
     --not_familiar(3,5)]).

input_clause(three_not_familiar_5_1_4,theorem,
    [--not_familiar(5,1),
     --not_familiar(1,4),
     --not_familiar(4,5)]).

input_clause(three_not_familiar_5_1_6,theorem,
    [--not_familiar(5,1),
     --not_familiar(1,6),
     --not_familiar(6,5)]).

%----X=5
%----Y=2
%----Z=1-6
input_clause(three_not_familiar_5_2_1,theorem,
    [--not_familiar(5,2),
     --not_familiar(2,1),
     --not_familiar(1,5)]).

input_clause(three_not_familiar_5_2_3,theorem,
    [--not_familiar(5,2),
     --not_familiar(2,3),
     --not_familiar(3,5)]).

input_clause(three_not_familiar_5_2_4,theorem,
    [--not_familiar(5,2),
     --not_familiar(2,4),
     --not_familiar(4,5)]).

input_clause(three_not_familiar_5_2_6,theorem,
    [--not_familiar(5,2),
     --not_familiar(2,6),
     --not_familiar(6,5)]).

%----X=5
%----Y=3
%----Z=1-6
input_clause(three_not_familiar_5_3_1,theorem,
    [--not_familiar(5,3),
     --not_familiar(3,1),
     --not_familiar(1,5)]).

input_clause(three_not_familiar_5_3_2,theorem,
    [--not_familiar(5,3),
     --not_familiar(3,2),
     --not_familiar(2,5)]).

input_clause(three_not_familiar_5_3_4,theorem,
    [--not_familiar(5,3),
     --not_familiar(3,4),
     --not_familiar(4,5)]).

input_clause(three_not_familiar_5_3_6,theorem,
    [--not_familiar(5,3),
     --not_familiar(3,6),
     --not_familiar(6,5)]).

%----X=5
%----Y=4
%----Z=1-6
input_clause(three_not_familiar_5_4_1,theorem,
    [--not_familiar(5,4),
     --not_familiar(4,1),
     --not_familiar(1,5)]).

input_clause(three_not_familiar_5_4_2,theorem,
    [--not_familiar(5,4),
     --not_familiar(4,2),
     --not_familiar(2,5)]).

input_clause(three_not_familiar_5_4_3,theorem,
    [--not_familiar(5,4),
     --not_familiar(4,3),
     --not_familiar(3,5)]).

input_clause(three_not_familiar_5_4_6,theorem,
    [--not_familiar(5,4),
     --not_familiar(4,6),
     --not_familiar(6,5)]).

%----X=5
%----Y=5
%----Z=1-6
%----X=5
%----Y=6
%----Z=1-6
input_clause(three_not_familiar_5_6_1,theorem,
    [--not_familiar(5,6),
     --not_familiar(6,1),
     --not_familiar(1,5)]).

input_clause(three_not_familiar_5_6_2,theorem,
    [--not_familiar(5,6),
     --not_familiar(6,2),
     --not_familiar(2,5)]).

input_clause(three_not_familiar_5_6_3,theorem,
    [--not_familiar(5,6),
     --not_familiar(6,3),
     --not_familiar(3,5)]).

input_clause(three_not_familiar_5_6_4,theorem,
    [--not_familiar(5,6),
     --not_familiar(6,4),
     --not_familiar(4,5)]).

%----X=6
%----Y=1
%----Z=1-6
input_clause(three_not_familiar_6_1_2,theorem,
    [--not_familiar(6,1),
     --not_familiar(1,2),
     --not_familiar(2,6)]).

input_clause(three_not_familiar_6_1_3,theorem,
    [--not_familiar(6,1),
     --not_familiar(1,3),
     --not_familiar(3,6)]).

input_clause(three_not_familiar_6_1_4,theorem,
    [--not_familiar(6,1),
     --not_familiar(1,4),
     --not_familiar(4,6)]).

input_clause(three_not_familiar_6_1_5,theorem,
    [--not_familiar(6,1),
     --not_familiar(1,5),
     --not_familiar(5,6)]).

%----X=6
%----Y=2
%----Z=1-6
input_clause(three_not_familiar_6_2_1,theorem,
    [--not_familiar(6,2),
     --not_familiar(2,1),
     --not_familiar(1,6)]).

input_clause(three_not_familiar_6_2_3,theorem,
    [--not_familiar(6,2),
     --not_familiar(2,3),
     --not_familiar(3,6)]).

input_clause(three_not_familiar_6_2_4,theorem,
    [--not_familiar(6,2),
     --not_familiar(2,4),
     --not_familiar(4,6)]).

input_clause(three_not_familiar_6_2_5,theorem,
    [--not_familiar(6,2),
     --not_familiar(2,5),
     --not_familiar(5,6)]).

%----X=6
%----Y=3
%----Z=1-6
input_clause(three_not_familiar_6_3_1,theorem,
    [--not_familiar(6,3),
     --not_familiar(3,1),
     --not_familiar(1,6)]).

input_clause(three_not_familiar_6_3_2,theorem,
    [--not_familiar(6,3),
     --not_familiar(3,2),
     --not_familiar(2,6)]).

input_clause(three_not_familiar_6_3_4,theorem,
    [--not_familiar(6,3),
     --not_familiar(3,4),
     --not_familiar(4,6)]).

input_clause(three_not_familiar_6_3_5,theorem,
    [--not_familiar(6,3),
     --not_familiar(3,5),
     --not_familiar(5,6)]).

%----X=6
%----Y=4
%----Z=1-6
input_clause(three_not_familiar_6_4_1,theorem,
    [--not_familiar(6,4),
     --not_familiar(4,1),
     --not_familiar(1,6)]).

input_clause(three_not_familiar_6_4_2,theorem,
    [--not_familiar(6,4),
     --not_familiar(4,2),
     --not_familiar(2,6)]).

input_clause(three_not_familiar_6_4_3,theorem,
    [--not_familiar(6,4),
     --not_familiar(4,3),
     --not_familiar(3,6)]).

input_clause(three_not_familiar_6_4_5,theorem,
    [--not_familiar(6,4),
     --not_familiar(4,5),
     --not_familiar(5,6)]).

%----X=6
%----Y=5
%----Z=1-6
input_clause(three_not_familiar_6_5_1,theorem,
    [--not_familiar(6,5),
     --not_familiar(5,1),
     --not_familiar(1,6)]).

input_clause(three_not_familiar_6_5_2,theorem,
    [--not_familiar(6,5),
     --not_familiar(5,2),
     --not_familiar(2,6)]).

input_clause(three_not_familiar_6_5_3,theorem,
    [--not_familiar(6,5),
     --not_familiar(5,3),
     --not_familiar(3,6)]).

input_clause(three_not_familiar_6_5_4,theorem,
    [--not_familiar(6,5),
     --not_familiar(5,4),
     --not_familiar(4,6)]).

%----X=6
%----Y=6
%----Z=1-6
%--------------------------------------------------------------------------
