%--------------------------------------------------------------------------
% File     : PUZ028=Party-1 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Puzzles
% Problem  : People at a party
% Version  : 
% English  : We can always choose 3 persons who are either familiar with 
%            each other or not familiar with each other, from 6 persons 
%            who meet at a party.

% Refs     : ICOT (1991), Exhibition brochure from IJCAI'91.
% Source   : [ICOT, 1991]
% Names    : 

% Status   : satisfiable
% Syntax   : Number of clauses           :   15 (   1 non-Horn)(  11 unit)
%            Number of literals          :   25 (   0 equality)
%            Number of predicate symbols :    4 (   0 propositional)
%            Number of function symbols  :    6 (   6 constant)
%            Number of variables         :   11 (   0 singleton)
%            Maximal clause size         :    5
%            Maximal term depth          :    1

% Comments : 
%--------------------------------------------------------------------------
input_clause(person1,axiom,
    [++person(one)]).

input_clause(person2,axiom,
    [++person(two)]).

input_clause(person3,axiom,
    [++person(three)]).

input_clause(person4,axiom,
    [++person(four)]).

input_clause(person5,axiom,
    [++person(five)]).

input_clause(person6,axiom,
    [++person(six)]).

input_clause(order1,axiom,
    [++after(one,two)]).

input_clause(order2,axiom,
    [++after(two,three)]).

input_clause(order3,axiom,
    [++after(three,four)]).

input_clause(order4,axiom,
    [++after(four,five)]).

input_clause(order5,axiom,
    [++after(five,six)]).

input_clause(transitivity_of_order,axiom,
    [++after(Large,Small),
     --after(Large,Medium),
     --after(Medium,Small)]).

input_clause(familiar_or_not,axiom,
    [++familiar(X,Y),
     ++not_familiar(X,Y),
     --person(X),
     --person(Y),
     --after(X,Y)]).

input_clause(three_familiar,theorem,
    [--familiar(X1,X2),
     --familiar(X2,X3),
     --familiar(X3,X1)]).

input_clause(three_not_familiar,theorem,
    [--not_familiar(X1,X2),
     --not_familiar(X2,X3),
     --not_familiar(X3,X1)]).
%--------------------------------------------------------------------------
