%--------------------------------------------------------------------------
% File     : PUZ026=KKnave39-1 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Puzzles
% Problem  : Knights and Knaves #39
% Version  : 
% English  : There is an island with exactly three types 
%            of people --truthtellers who always tell the truth, and liars 
%            who always lie, and normals who sometimes tell the truth and 
%            sometimes lie. We are given three people, A, B, C, one 
%            of whom is a truthteller, one a liar, and one a normal (but 
%            not neccesarily in that order). They make the following 
%            statements. A: I am normal; B: That is true. C: I am not 
%            normal. What are A,B, and C ? Answer: A is a liar, 
%            B is a normal, and C is a truthteller.

% Refs     : Smullyan R.M. (1978), What is the name of this book? :
%            The riddle of Dracula and other logical puzzles, 
%            Prentice-Hall, Englewood Cliffs, NJ.
% Source   : [ANL]
% Names    : Problem 39 [Smullyan, 1978]
%          : tandl39.ver1.in [ANL]

% Status   : 
% Syntax   : Number of clauses           :   23 (   4 non-Horn)(   6 unit)
%            Number of literals          :   54 (   0 equality)
%            Number of predicate symbols :    2 (   0 propositional)
%            Number of function symbols  :    8 (   3 constant)
%            Number of variables         :   35 (   9 singleton)
%            Maximal clause size         :    4
%            Maximal term depth          :    3

% Comments : 
%--------------------------------------------------------------------------
%----Include axioms on truthtellers, liars and normal people 
include('Axioms/PUZ003-0.ax').
%--------------------------------------------------------------------------
input_clause(not_normal_and_not_normal,axiom,
    [--a_truth(not_normal(X)),
     --a_truth(normal(X))]).

input_clause(normal_or_not_normal,axiom,
    [++a_truth(not_normal(X)),
     ++a_truth(normal(X))]).

%----The next 6 clause says there is one each of normal, truthteller and 
%----liar.
input_clause(not_two_truthtellers1,axiom,
    [--people(X,Y,Z),
     --a_truth(truthteller(X)),
     --a_truth(truthteller(Y))]).

input_clause(not_two_truthtellers2,axiom,
    [--people(X,Y,Z),
     --a_truth(truthteller(X)),
     --a_truth(truthteller(Z))]).

input_clause(not_two_liars1,axiom,
    [--people(X,Y,Z),
     --a_truth(liar(X)),
     --a_truth(liar(Y))]).

input_clause(not_two_liars2,axiom,
    [--people(X,Y,Z),
     --a_truth(liar(X)),
     --a_truth(liar(Z))]).

input_clause(not_two_normal1,axiom,
    [--people(X,Y,Z),
     --a_truth(normal(X)),
     --a_truth(normal(Y))]).

input_clause(not_two_normal2,axiom,
    [--people(X,Y,Z),
     --a_truth(normal(X)),
     --a_truth(normal(Z))]).

input_clause(a_b_c_are_people,hypothesis,
    [++people(a,b,c)]).

input_clause(b_c_a_are_people,hypothesis,
    [++people(b,c,a)]).

input_clause(c_b_a_are_people,hypothesis,
    [++people(c,b,a)]).

input_clause(a_says_a_normal,hypothesis,
    [++a_truth(says(a,normal(a)))]).

input_clause(b_says_a_normal,hypothesis,
    [++a_truth(says(b,normal(a)))]).

input_clause(c_says_c_not_normal,hypothesis,
    [++a_truth(says(c,not_normal(c)))]).

input_clause(prove_one_of_each,theorem,
    [--a_truth(liar(Liar)),
     --a_truth(normal(Normal)),
     --a_truth(truthteller(Truthteller))]).
%--------------------------------------------------------------------------
