%--------------------------------------------------------------------------
% File     : PUZ025=KKnave35-1 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Puzzles
% Problem  : Knights and Knaves #35
% Version  : 
% English  : There is an island with exactly two types 
%            of people--truthtellers who always tell the truth and liars 
%            who always lie. There are a group of three people, A, B, and 
%            C on the island. A and B make the following statements. 
%            A: "B and C are the same type". Someone asks "Are A and 
%            B of the same type ? " What does C answer ? Answer: "yes"

% Refs     : Smullyan R.M. (1978), What is the name of this book? :
%            The riddle of Dracula and other logical puzzles, 
%            Prentice-Hall, Englewood Cliffs, NJ.
% Source   : [ANL]
% Names    : Problem 35 [Smullyan, 1978]
%          : tandl35.ver1.in [ANL]

% Status   : 
% Syntax   : Number of clauses           :   24 (   6 non-Horn)(   7 unit)
%            Number of literals          :   61 (   0 equality)
%            Number of predicate symbols :    4 (   0 propositional)
%            Number of function symbols  :    9 (   5 constant)
%            Number of variables         :   35 (   3 singleton)
%            Maximal clause size         :    4
%            Maximal term depth          :    3

% Comments : 
%--------------------------------------------------------------------------
%----Include axioms for truthtellers and liars 
include('Axioms/PUZ002-0.ax').
%--------------------------------------------------------------------------
%----The next 6 clause define what is meant by being of equal type 
input_clause(two_liars_are_equal,axiom,
    [--people(X,Y,Z),
     --a_truth(liar(X)),
     --a_truth(liar(Y)),
     ++a_truth(equal_type(X,Y))]).

input_clause(two_truthtellers_are_equal,axiom,
    [--people(X,Y,Z),
     --a_truth(truthteller(X)),
     --a_truth(truthteller(Y)),
     ++a_truth(equal_type(X,Y))]).

input_clause(truthteller_equals_truthtller,axiom,
    [--a_truth(equal_type(X,Y)),
     --a_truth(truthteller(X)),
     ++a_truth(truthteller(Y))]).

input_clause(liar_equals_liar,axiom,
    [--a_truth(equal_type(X,Y)),
     --a_truth(liar(X)),
     ++a_truth(liar(Y))]).

input_clause(truthteller_not_equal_liar,axiom,
    [--a_truth(truthteller(X)),
     ++a_truth(equal_type(X,Y)),
     ++a_truth(liar(Y))]).

input_clause(liar_not_equal_truthteller,axiom,
    [--a_truth(liar(X)),
     ++a_truth(equal_type(X,Y)),
     ++a_truth(truthteller(Y))]).

input_clause(symmetry_of_equal_type,axiom,
    [--a_truth(equal_type(X,Y)),
     ++a_truth(equal_type(Y,X))]).

input_clause(truthteller_identifies_truths,axiom,
    [--ask_1_if_2(X,Y),
     --a_truth(truthteller(X)),
     --a_truth(Y),
     ++answer(yes)]).

input_clause(truthteller_denies_lies,axiom,
    [--ask_1_if_2(X,Y),
     --a_truth(truthteller(X)),
     ++a_truth(Y),
     ++answer(no)]).

input_clause(liar_denies_truths,axiom,
    [--ask_1_if_2(X,Y),
     --a_truth(liar(X)),
     --a_truth(Y),
     ++answer(no)]).

input_clause(liar_supports_lies,axiom,
    [--ask_1_if_2(X,Y),
     --a_truth(liar(X)),
     ++a_truth(Y),
     ++answer(yes)]).

input_clause(b_c_a_are_people,hypothesis,
    [++people(b,c,a)]).

%----bugs here 
input_clause(a_b_c_are_people,hypothesis,
    [++people(a,b,a)]).

input_clause(a_c_b_are_people,hypothesis,
    [++people(a,c,b)]).

input_clause(c_b_a_are_people,hypothesis,
    [++people(c,b,a)]).

input_clause(a_says_b_and_c_equal,hypothesis,
    [++a_truth(says(a,equal_type(b,c)))]).

input_clause(ask_c_if_a_and_b_equal,hypothesis,
    [++ask_1_if_2(c,equal_type(a,b))]).

input_clause(prove_there_is_an_answer,theorem,
    [--answer(Answer)]).
%--------------------------------------------------------------------------
