%--------------------------------------------------------------------------
% File     : PUZ024=KKnave31-1 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Puzzles
% Problem  : Knights and Knaves #31
% Version  : 
% English  : There is an island with exactly two types 
%            of people--truthtellers who always tell the truth and liars 
%            who always lie. There are a group of three people, A, B, and 
%            C on the island. A and B make the following statements. 
%            A: All of us are liars; B: Exactly one 
%            of us is a truthteller. What are A, B, and C? Answer: 
%            A is a liar, B is a truthteller, and C is a liar.

% Refs     : Smullyan R.M. (1978), What is the name of this book? :
%            The riddle of Dracula and other logical puzzles, 
%            Prentice-Hall, Englewood Cliffs, NJ.
% Source   : [ANL]
% Names    : Problem 31 [Smullyan, 1978]
%          : tandl31.ver1.in [ANL]

% Status   : 
% Syntax   : Number of clauses           :   20 (   6 non-Horn)(   6 unit)
%            Number of literals          :   60 (   0 equality)
%            Number of predicate symbols :    2 (   0 propositional)
%            Number of function symbols  :    8 (   5 constant)
%            Number of variables         :   35 (   3 singleton)
%            Maximal clause size         :    5
%            Maximal term depth          :    2

% Comments : 
%--------------------------------------------------------------------------
%----Include axioms for truthtellers and liars 
include('Axioms/PUZ002-0.ax').
%--------------------------------------------------------------------------
%----The next 6 clauses define what is meant by exactly one 
%----is a truthteller.
input_clause(one_says_one_truthteller,axiom,
    [--a_truth(says(X,one_truthteller)),
     --people(X,Y,Z),
     --a_truth(truthteller(X)),
     --a_truth(truthteller(Y)),
     --a_truth(truthteller(Z))]).

input_clause(one_is_the_truth_teller,axiom,
    [--a_truth(one_truthteller),
     --people(X,Y,Z),
     ++a_truth(truthteller(X)),
     ++a_truth(truthteller(Y)),
     ++a_truth(truthteller(Z))]).

input_clause(one_is_not_the_truthteller,axiom,
    [--a_truth(one_truthteller),
     --people(X,Y,Z),
     --a_truth(truthteller(Y)),
     --a_truth(truthteller(X)),
     --a_truth(truthteller(Z))]).

input_clause(one_truthteller_two_liars,axiom,
    [--a_truth(one_truthteller),
     --people(X,Y,Z),
     --a_truth(liar(X)),
     --a_truth(truthteller(Y)),
     ++a_truth(liar(Z))]).

input_clause(two_truthtellers,axiom,
    [++a_truth(one_truthteller),
     --people(X,Y,Z),
     --a_truth(liar(X)),
     --a_truth(truthteller(Y)),
     ++a_truth(truthteller(Z))]).

input_clause(three_liars,axiom,
    [++a_truth(one_truthteller),
     --people(X,Y,Z),
     --a_truth(liar(X)),
     --a_truth(liar(Y)),
     ++a_truth(liar(Z))]).

%----If x says that 'all of us' are liars then, all the persons may 
%----be liars.
input_clause(speaker_is_lying,axiom,
    [--a_truth(says(X,all_are_liars)),
     --people(X,Y,Z),
     --a_truth(truthteller(X))]).

input_clause(all_truthtellers,axiom,
    [++a_truth(all_are_liars),
     --people(X,Y,Z),
     ++a_truth(truthteller(X)),
     ++a_truth(truthteller(Y)),
     ++a_truth(truthteller(Z))]).

input_clause(b_c_a_people,hypothesis,
    [++people(b,c,a)]).

input_clause(a_c_b_people,hypothesis,
    [++people(a,c,b)]).

input_clause(c_b_a_people,hypothesis,
    [++people(c,b,a)]).

input_clause(a_says_all_are_liars,hypothesis,
    [++a_truth(says(a,all_are_liars))]).

input_clause(b_says_one_truthteller,hypothesis,
    [++a_truth(says(b,one_truthteller))]).

%----This is an honest way of doing this. A simpler version could simply 
%----prove that A and C are a liars, and  B is a truthteller 
input_clause(prove_there_is_a_truthteller,theorem,
    [--a_truth(truthteller(Truthteller))]).
%--------------------------------------------------------------------------
