%--------------------------------------------------------------------------
% File     : PUZ023=KKnave27-1 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Puzzles
% Problem  : Knights and Knaves #27
% Version  : 
% English  : There is an island with exactly two types of people :
%            truthtellers who always tell the truth and liars who always 
%            lie. There are a group of three people, A, B, and C on the 
%            island. A stranger passes by and asks A, "How many 
%            truthtellers are among you ?" A answers indistinctly. So the 
%            stranger asks B, "what did A say?". B replies "A said that 
%            there is exactly one truthteller among us." Then C says, 
%            "Don't believe B; he is lying!" What are B and C. Answer: 
%            B is a liar and C is a truth-teller.

% Refs     : Smullyan R.M. (1978), What is the name of this book? :
%            The riddle of Dracula and other logical puzzles, 
%            Prentice-Hall, Englewood Cliffs, NJ.
% Source   : [ANL]
% Names    : Problem 27 [Smullyan, 1978]
%          : tandl27.ver1.in [ANL]

% Status   : 
% Syntax   : Number of clauses           :   22 (   6 non-Horn)(   5 unit)
%            Number of literals          :   65 (   0 equality)
%            Number of predicate symbols :    3 (   0 propositional)
%            Number of function symbols  :   12 (   9 constant)
%            Number of variables         :   32 (   4 singleton)
%            Maximal clause size         :    5
%            Maximal term depth          :    3

% Comments : 
%--------------------------------------------------------------------------
%----Include axioms for truthtellers and liars 
include('Axioms/PUZ002-0.ax').
%--------------------------------------------------------------------------
input_clause(one_is_the_truthteller,axiom,
    [--people(X,Y,Z),
     --a_truth(one_truthteller),
     ++a_truth(truthteller(X)),
     ++a_truth(truthteller(Y)),
     ++a_truth(truthteller(Z))]).

input_clause(two_truthtellers1,axiom,
    [--people(X,Y,Z),
     --a_truth(truthteller(X)),
     --a_truth(truthteller(Y)),
     --a_truth(one_truthteller)]).

input_clause(two_truthtellers2,axiom,
    [--people(X,Y,Z),
     --a_truth(truthteller(X)),
     --a_truth(truthteller(Z)),
     --a_truth(one_truthteller)]).

input_clause(two_truthtellers3,axiom,
    [--people(X,Y,Z),
     --a_truth(truthteller(Y)),
     --a_truth(truthteller(Z)),
     --a_truth(one_truthteller)]).

input_clause(identify_one_truthteller1,axiom,
    [--people(X,Y,Z),
     ++a_truth(one_truthteller),
     --a_truth(truthteller(X)),
     ++a_truth(truthteller(Y)),
     ++a_truth(truthteller(Z))]).

input_clause(identify_one_truthteller2,axiom,
    [--people(X,Y,Z),
     ++a_truth(one_truthteller),
     --a_truth(truthteller(Y)),
     ++a_truth(truthteller(X)),
     ++a_truth(truthteller(Z))]).

input_clause(identify_one_truthteller3,axiom,
    [--people(X,Y,Z),
     ++a_truth(one_truthteller),
     --a_truth(truthteller(Z)),
     ++a_truth(truthteller(Y)),
     ++a_truth(truthteller(X))]).

input_clause(a_b_and_c_are_people,hypothesis,
    [++people(a,b,c)]).

input_clause(a_says_garbage,hypothesis,
    [++a_truth(says(a,garbage))]).

input_clause(b_says_a_says_one_truthteller,hypothesis,
    [++a_truth(says(b,says(a,one_truthteller)))]).

input_clause(c_says_b_lies,hypothesis,
    [++a_truth(says(c,liar(b)))]).

%----This is an honest way of doing this. A simpler version could simply 
%----prove that B is a liar and C is a truth-teller. 
input_clause(b_and_c_liars,hypothesis,
    [--a_truth(liar(b)),
     --a_truth(liar(c)),
     ++an_answer(b_and_c_liars)]).

input_clause(b_liar_and_c_truthteller,hypothesis,
    [--a_truth(liar(b)),
     --a_truth(truthteller(c)),
     ++an_answer(b_liar_and_c_truthteller)]).

input_clause(b_truthteller_and_c_liar,hypothesis,
    [--a_truth(truthteller(b)),
     --a_truth(liar(c)),
     ++an_answer(b_truthteller_and_c_liar)]).

input_clause(b_and_c_truthtellers,hypothesis,
    [--a_truth(truthteller(b)),
     --a_truth(truthteller(c)),
     ++an_answer(b_and_c_truthtellers)]).

input_clause(prove_there_is_an_answer,theorem,
    [--an_answer(X)]).
%--------------------------------------------------------------------------
