%--------------------------------------------------------------------------
% File     : PUZ022=Borders2-1 : TPTP v1.1.1. Bugfixed v1.1.0.
% Domain   : Puzzles
% Problem  : An ocean that borders on two adjacent Australian states
% Version  : 
% English  : There is a database of assertions about Australian states and 
%            oceans and their relationships. Find which ocean borders 
%            on two adjacent Australian states.

% Refs     : Plaisted D.A. (1982), A Simplified Problem Reduction Format, 
%            Artificial Intelligence 18(X), 227-261.
% Source   : [TPTP]
% Names    : Problem 5.6 [Plaisted, 1982]

% Status   : 
% Syntax   : Number of clauses           :   33 (   0 non-Horn)(  31 unit)
%            Number of literals          :   39 (   0 equality)
%            Number of predicate symbols :    3 (   0 propositional)
%            Number of function symbols  :   11 (  11 constant)
%            Number of variables         :    5 (   0 singleton)
%            Maximal clause size         :    6
%            Maximal term depth          :    1

% Comments : Inspired by Problem 5.6 in [Plaisted, 1992]
%--------------------------------------------------------------------------
input_clause(symmetry_of_borders,axiom,
    [--borders(Y,X),
     ++borders(X,Y)]).

input_clause(atlantic,theorem,
    [++ocean(atlantic)]).

input_clause(indian,theorem,
    [++ocean(indian)]).

input_clause(pacific,theorem,
    [++ocean(pacific)]).

input_clause(southern,theorem,
    [++ocean(southern)]).

input_clause(western_australia,theorem,
    [++state(western_australia)]).

input_clause(northern_territory,theorem,
    [++state(northern_territory)]).

input_clause(queensland,theorem,
    [++state(queensland)]).

input_clause(south_australia,theorem,
    [++state(south_australia)]).

input_clause(new_south_wales,theorem,
    [++state(new_south_wales)]).

input_clause(victoria,theorem,
    [++state(victoria)]).

input_clause(tasmania,theorem,
    [++state(tasmania)]).

input_clause(wa_nt,theorem,
    [++borders(western_australia,northern_territory)]).

input_clause(wa_sa,theorem,
    [++borders(western_australia,south_australia)]).

input_clause(sa_nt,theorem,
    [++borders(south_australia,northern_territory)]).

input_clause(sa_qld,theorem,
    [++borders(south_australia,queensland)]).

input_clause(sa_nsw,theorem,
    [++borders(south_australia,new_south_wales)]).

input_clause(sa_vic,theorem,
    [++borders(south_australia,victoria)]).

input_clause(nt_qld,theorem,
    [++borders(northern_territory,queensland)]).

input_clause(qld_nsw,theorem,
    [++borders(queensland,new_south_wales)]).

input_clause(nsw_vic,theorem,
    [++borders(new_south_wales,victoria)]).

input_clause(indian_wa,theorem,
    [++borders(indian,western_australia)]).

input_clause(indian_nt,theorem,
    [++borders(indian,northern_territory)]).

input_clause(indian_qld,theorem,
    [++borders(indian,queensland)]).

input_clause(southern_wa,theorem,
    [++borders(southern,western_australia)]).

input_clause(southern_sa,theorem,
    [++borders(southern,south_australia)]).

input_clause(southern_vic,theorem,
    [++borders(southern,victoria)]).

input_clause(southern_tas,theorem,
    [++borders(southern,tasmania)]).

input_clause(pacific_qld,theorem,
    [++borders(pacific,queensland)]).

input_clause(pacific_nsw,theorem,
    [++borders(pacific,new_south_wales)]).

input_clause(pacific_vic,theorem,
    [++borders(pacific,victoria)]).

input_clause(pacific_tas,theorem,
    [++borders(pacific,tasmania)]).

input_clause(prove_borders,theorem,
    [--state(State1),
     --state(State2),
     --borders(State1,State2),
     --borders(State1,Ocean),
     --borders(State2,Ocean),
     --ocean(Ocean)]).
%--------------------------------------------------------------------------
