%--------------------------------------------------------------------------
% File     : PUZ021=KKnave2-1 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Puzzles
% Problem  : How to Win a Bride
% Version  : 
% English  : Suppose you are an inhabitant of the island of 'knights' and 
%            'knaves'. The knights always tell the truth and the knaves 
%            always lie. You fall in love with a girl there and wish 
%            to marry her. However, this girl has strange tastes; for some 
%            odd reason she does not wish to marry a knight; she wants 
%            to marry only a knave. But she wants a rich knave, not a poor 
%            one. (We assume for convenience that everyone is classified 
%            as either rich or poor.) Suppose, in fact, that you are 
%            a rich knave. You are allowed to make only one statement, can 
%            you convince her that you are a rich knave?

% Refs     : Smullyan R.M. (1978), What is the name of this book? :
%            The riddle of Dracula and other logical puzzles, 
%            Prentice-Hall, Englewood Cliffs, NJ.
%          : Ohlbach H.J. (1985), Predicate Logic Hacker Tricks, 
%            In Journal of Automated Reasoning 1(4), Kluwer Academic 
%            Publishers, Dordrecht, The Netherlands, 435-440.
% Source   : [Ohlbach, 1985]
% Names    : Problem 95 [Smullyan, 1978]
%          : How to Win a Bride [Ohlbach, 1985]

% Status   : 
% Syntax   : Number of clauses           :   13 (   4 non-Horn)(   0 unit)
%            Number of literals          :   31 (   0 equality)
%            Number of predicate symbols :    2 (   0 propositional)
%            Number of function symbols  :    6 (   1 constant)
%            Number of variables         :   31 (   2 singleton)
%            Maximal clause size         :    3
%            Maximal term depth          :    3

% Comments : 
%--------------------------------------------------------------------------
input_clause(not_knight_and_knave,axiom,
    [--a_truth(knight(X),Y),
     --a_truth(knave(X),Y)]).

input_clause(knight_or_knave,axiom,
    [++a_truth(knight(X),Y),
     ++a_truth(knave(X),Y)]).

input_clause(not_rich_and_poor,axiom,
    [--a_truth(rich(X),Y),
     --a_truth(poor(X),Y)]).

input_clause(rich_or_poor,axiom,
    [++a_truth(rich(X),Y),
     ++a_truth(poor(X),Y)]).

input_clause(knights_tell_truth1,axiom,
    [--a_truth(knight(X),Z),
     --says(X,Y),
     ++a_truth(Y,Z)]).

input_clause(knights_tell_truth2,axiom,
    [--a_truth(knight(X),Z),
     ++says(X,Y),
     --a_truth(Y,Z)]).

input_clause(knaves_lie1,axiom,
    [--a_truth(knave(X),Z),
     --says(X,Y),
     --a_truth(Y,Z)]).

input_clause(knaves_lie2,axiom,
    [--a_truth(knave(X),Z),
     ++says(X,Y),
     ++a_truth(Y,Z)]).

input_clause(conjunction1,axiom,
    [--a_truth(and(X,Y),Z),
     ++a_truth(X,Z)]).

input_clause(conjunction2,axiom,
    [--a_truth(and(X,Y),Z),
     ++a_truth(Y,Z)]).

input_clause(conjunction3,axiom,
    [++a_truth(and(X,Y),Z),
     --a_truth(X,Z),
     --a_truth(Y,Z)]).

input_clause(prove_statement_exists1,theorem,
    [--says(me,X),
     --a_truth(and(knave(me),rich(me)),X)]).

input_clause(prove_statement_exists2,theorem,
    [++says(me,X),
     ++a_truth(and(knave(me),rich(me)),X)]).
%--------------------------------------------------------------------------
