%--------------------------------------------------------------------------
% File     : PUZ020=KKnave1-1 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Puzzles
% Problem  : A knights & knaves problem, if he's a knight, so is she
% Version  : 
% English  : 

% Refs     : 
% Source   : [ANL]
% Names    : knightknave.in [ANL]

% Status   : 
% Syntax   : Number of clauses           :   29 (   3 non-Horn)(   6 unit)
%            Number of literals          :   67 (  18 equality)
%            Number of predicate symbols :    6 (   0 propositional)
%            Number of function symbols  :    3 (   2 constant)
%            Number of variables         :   38 (   2 singleton)
%            Maximal clause size         :    3
%            Maximal term depth          :    2

% Comments : 
%--------------------------------------------------------------------------
%----Include the axioms of equality 
include('Axioms/EQU001-0.ax').
%--------------------------------------------------------------------------
%----This axiom is omitted in the orginal, because of paramodulation 
input_clause(statement_by_substitutivity1,axiom,
    [--equal(A,B),
     ++equal(statement_by(A),statement_by(B))]).

%----Everyone's either a knight or a knave; statements are true or false.
input_clause(everyone_a_knight_or_knave,axiom,
    [--person(X),
     ++knight(X),
     ++knave(X)]).

input_clause(not_both_a_knight_and_knave,axiom,
    [--person(X),
     --knight(X),
     --knave(X)]).

input_clause(statements_are_true_or_false,axiom,
    [--says(X,Y),
     ++a_truth(Y),
     --a_truth(Y)]).

%----Rules about statements 
input_clause(people_do_not_equal_their_statements1,axiom,
    [--says(X,Y),
     --equal(X,Y)]).

input_clause(peoples_statements,axiom,
    [--says(X,Y),
     ++equal(Y,statement_by(X))]).

input_clause(people_do_not_equal_their_statement2,axiom,
    [--person(X),
     --equal(X,statement_by(Y))]).

input_clause(knights_make_true_statements,axiom,
    [--person(X),
     --a_truth(statement_by(X)),
     ++knight(X)]).

input_clause(knaves_make_false_statements,axiom,
    [--person(X),
     ++a_truth(statement_by(X)),
     ++knave(X)]).

%----Rules about equalities 
input_clause(substitutivity_for_knight,axiom,
    [--equal(X,Y),
     --knight(X),
     ++knight(Y)]).

input_clause(substitutivity_for_knave,axiom,
    [--equal(X,Y),
     --knave(X),
     ++knave(Y)]).

input_clause(substitutivity_for_person,axiom,
    [--equal(X,Y),
     --person(X),
     ++person(Y)]).

input_clause(substitutivity_for_says1,axiom,
    [--equal(X,Y),
     --says(X,Z),
     ++says(Y,Z)]).

input_clause(substitutivity_for_says2,axiom,
    [--equal(X,Y),
     --says(Z,X),
     ++says(Z,Y)]).

input_clause(substitutivity_for_true,axiom,
    [--equal(X,Y),
     --a_truth(X),
     ++a_truth(Y)]).

%----What knights say is true, what knaves say is false 
input_clause(knights_say_the_truth,axiom,
    [--knight(X),
     --says(X,Y),
     ++a_truth(Y)]).

input_clause(knaves_do_not_say_the_truth,axiom,
    [--knave(X),
     --says(X,Y),
     --a_truth(Y)]).

%----This is for the husband & wife problem; if he's a knight, then she 
%----is 
input_clause(husband,hypothesis,
    [++person(husband)]).

input_clause(wife,hypothesis,
    [++person(wife)]).

input_clause(husband_not_wife,hypothesis,
    [--equal(husband,wife)]).

input_clause(husband_makes_statements,hypothesis,
    [++says(husband,statement_by(husband))]).

input_clause(truthful_knight_husband_means_knight_wife,hypothesis,
    [--a_truth(statement_by(husband)),
     --knight(husband),
     ++knight(wife)]).

input_clause(knight_husband_makes_true_statements,hypothesis,
    [++a_truth(statement_by(husband)),
     --knight(husband)]).

input_clause(knight_wife_or_truthful_husband,hypothesis,
    [++a_truth(statement_by(husband)),
     ++knight(wife)]).

input_clause(knight_wife_means_truthful_husband,hypothesis,
    [--knight(wife),
     ++a_truth(statement_by(husband))]).

input_clause(prove_knight_husband,theorem,
    [--knight(husband)]).
%--------------------------------------------------------------------------
