%--------------------------------------------------------------------------
% File     : PUZ019=Jobs-1 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Puzzles
% Problem  : The Jobs Puzzles
% Version  : 
% English  : There are four people: Roberta, Thelma, Steve, and Pete. 
%            Among them they hold eight different jobs.
%            Each holds exactly two jobs.
%            The jobs are: chef, guard, nurse, telephone operator, police 
%            officer (either gender), teacher, actor, and boxer. The job 
%            of a nurse is held by a male.
%            The husband of the chef is the telephone operator.
%            Roberta is not a boxer.
%            Pete has no education past the ninth grade.
%            Roberta, the chef, and the police officer went golfing 
%            together.
%            Question : Who holds which job ?

% Refs     : Wos L.A., Overbeek R., Lusk E., Boyle J. (1992), Automated
%            Reasoning, 2nd edition, McGraw-Hill.
% Source   : [ANL]
% Names    : jobs.ver1.in [ANL]

% Status   : 
% Syntax   : Number of clauses           :   63 (   4 non-Horn)(  43 unit)
%            Number of literals          :  104 (   0 equality)
%            Number of predicate symbols :    7 (   0 propositional)
%            Number of function symbols  :   13 (  13 constant)
%            Number of variables         :   40 (  10 singleton)
%            Maximal clause size         :    8
%            Maximal term depth          :    1

% Comments : 
%--------------------------------------------------------------------------
input_clause(reflexivity_for_equal_people,axiom,
    [++equal_people(X,X)]).

input_clause(reflexivity_for_equal_jobs,axiom,
    [++equal_jobs(X,X)]).

input_clause(symmetry_of_equal_people,axiom,
    [--equal_people(X,Y),
     ++equal_people(Y,X)]).

input_clause(symmetry_of_equal_jobs,axiom,
    [--equal_jobs(X,Y),
     ++equal_jobs(Y,X)]).

input_clause(roberta_not_thelma,axiom,
    [--equal_people(roberta,thelma)]).

input_clause(roberta_not_pete,axiom,
    [--equal_people(roberta,peteacher)]).

input_clause(roberta_not_steve,axiom,
    [--equal_people(roberta,steve)]).

input_clause(pete_not_thelma,axiom,
    [--equal_people(pete,thelma)]).

input_clause(pete_not_steve,axiom,
    [--equal_people(pete,steve)]).

input_clause(chef_not_guard,axiom,
    [--equal_jobs(chef,guard)]).

input_clause(chef_not_nurse,axiom,
    [--equal_jobs(chef,nurse)]).

input_clause(chef_not_operator,axiom,
    [--equal_jobs(chef,operator)]).

input_clause(chef_not_police,axiom,
    [--equal_jobs(chef,police)]).

input_clause(chef_not_actor,axiom,
    [--equal_jobs(chef,actor)]).

input_clause(chef_not_boxer,axiom,
    [--equal_jobs(chef,boxer)]).

input_clause(chef_not_teacher,axiom,
    [--equal_jobs(chef,teacher)]).

input_clause(guard_not_nurse,axiom,
    [--equal_jobs(guard,nurse)]).

input_clause(guard_not_operator,axiom,
    [--equal_jobs(guard,operator)]).

input_clause(guard_not_police,axiom,
    [--equal_jobs(guard,police)]).

input_clause(guard_not_actor,axiom,
    [--equal_jobs(guard,actor)]).

input_clause(guard_not_boxer,axiom,
    [--equal_jobs(guard,boxer)]).

input_clause(guard_not_teacher,axiom,
    [--equal_jobs(guard,teacher)]).

input_clause(nurse_not_operator,axiom,
    [--equal_jobs(nurse,operator)]).

input_clause(nurse_not_police,axiom,
    [--equal_jobs(nurse,police)]).

input_clause(nurse_not_actor,axiom,
    [--equal_jobs(nurse,actor)]).

input_clause(nurse_not_boxer,axiom,
    [--equal_jobs(nurse,boxer)]).

input_clause(nurse_not_teacher,axiom,
    [--equal_jobs(nurse,teacher)]).

input_clause(operator_not_police,axiom,
    [--equal_jobs(operator,police)]).

input_clause(operator_not_actor,axiom,
    [--equal_jobs(operator,actor)]).

input_clause(operator_not_boxer,axiom,
    [--equal_jobs(operator,boxer)]).

input_clause(operator_not_teacher,axiom,
    [--equal_jobs(operator,teacher)]).

input_clause(police_not_actor,axiom,
    [--equal_jobs(police,actor)]).

input_clause(police_not_boxer,axiom,
    [--equal_jobs(police,boxer)]).

input_clause(police_not_teacher,axiom,
    [--equal_jobs(police,teacher)]).

input_clause(actor_not_boxer,axiom,
    [--equal_jobs(actor,boxer)]).

input_clause(actor_not_teacher,axiom,
    [--equal_jobs(actor,teacher)]).

input_clause(boxer_not_teacher,axiom,
    [--equal_jobs(boxer,teacher)]).

input_clause(nurse_is_male,axiom,
    [--has_job(X,nurse),
     ++male(X)]).

input_clause(actor_is_male,axiom,
    [--has_job(X,actor),
     ++male(X)]).

input_clause(chef_is_female,axiom,
    [--has_job(X,chef),
     ++female(X)]).

input_clause(nurse_is_educated,axiom,
    [--has_job(X,nurse),
     ++educated(X)]).

input_clause(teacher_is_educated,axiom,
    [--has_job(X,teacher),
     ++educated(X)]).

input_clause(police_is_educated,axiom,
    [--has_job(X,police),
     ++educated(X)]).

input_clause(chef_is_not_also_police,axiom,
    [--has_job(X,chef),
     --has_job(X,police)]).

input_clause(males_are_not_female,axiom,
    [--male(X),
     --female(X)]).

input_clause(everyone_male_or_female,axiom,
    [++male(X),
     ++female(X)]).

input_clause(husband_is_male,axiom,
    [--husband(X,Y),
     ++male(Y)]).

input_clause(wife_is_female,axiom,
    [--husband(X,Y),
     ++female(X)]).

input_clause(husband_of_chef_is_operator1,hypothesis,
    [--has_job(X,chef),
     --has_job(Y,operator),
     ++husband(X,Y)]).

input_clause(husband_of_chef_is_operator2,hypothesis,
    [--has_job(X,chef),
     ++has_job(Y,operator),
     --husband(X,Y)]).

input_clause(each_job_held_once,hypothesis,
    [--has_job(X,Z),
     --has_job(Y,Z),
     ++equal_people(X,Y)]).

input_clause(each_has_maximum_of_two_jobs,hypothesis,
    [--has_job(Z,U),
     --has_job(Z,X),
     --has_job(Z,Y),
     ++equal_jobs(U,X),
     ++equal_jobs(U,Y),
     ++equal_jobs(X,Y)]).

input_clause(every_job_is_used,hypothesis,
    [++has_job(roberta,X),
     ++has_job(thelma,X),
     ++has_job(pete,X),
     ++has_job(steve,X)]).

input_clause(everyone_works,hypothesis,
    [++has_job(X,chef),
     ++has_job(X,guard),
     ++has_job(X,nurse),
     ++has_job(X,operator),
     ++has_job(X,police),
     ++has_job(X,teacher),
     ++has_job(X,actor),
     ++has_job(X,boxer)]).

input_clause(pete_is_not_educated,hypothesis,
    [--educated(pete)]).

input_clause(roberta_is_not_chef,hypothesis,
    [--has_job(roberta,chef)]).

input_clause(roberta_is_not_boxer,hypothesis,
    [--has_job(roberta,boxer)]).

input_clause(roberta_is_not_police,hypothesis,
    [--has_job(roberta,police)]).

input_clause(steve_is_male,hypothesis,
    [++male(steve)]).

input_clause(pete_is_male,hypothesis,
    [++male(peteacher)]).

input_clause(roberta_is_female,hypothesis,
    [++female(roberta)]).

input_clause(thelma_is_female,hypothesis,
    [++female(thelma)]).

input_clause(find_who_has_each_job,theorem,
    [--has_job(X1,chef),
     --has_job(X2,guard),
     --has_job(X3,nurse),
     --has_job(X4,operator),
     --has_job(X5,police),
     --has_job(X6,teacher),
     --has_job(X7,actor),
     --has_job(X8,boxer)]).
%--------------------------------------------------------------------------
