%--------------------------------------------------------------------------
% File     : PUZ017=Houses-1 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Puzzles
% Problem  : The Houses
% Version  : 
% English  : There are 5 houses, 5 people, 5 colors, 5 drinks, 5 games, 
%            and 4 pets. Each house has a person, a color, a drink, and 
%            game, and all but one of the houses has a pet. The problem 
%            is to match each house with as many properties as possible. 
%             House 1 is at the left end and house 5 is at the right end. 
%             The Englishman lives in the Red house. The white house 
%            is left of the Green house. The Italian has a Guppy. Lemonade 
%            is drunk in the Green house. The Swede lives in the house 
%            where Coffee is drunk. The Toad lives in the house where 
%            Backgammon is played. Racquetball is played in the yellow 
%            house. Milk is drunk in the third house. The Russian lives 
%            in the first house. The Camel lives next to the house where 
%            Quoits is played. The Rat lives next to the house where 
%            Racquetball is played. Solitaire is played in the house where 
%            vodka is drunk. The American lives in the house where 
%            Charades is played. The Russian lives next to the Blue house.

% Refs     : 
% Source   : [ANL]
% Names    : houses.ver1.in [ANL]

% Status   : 
% Syntax   : Number of clauses           :  148 (  17 non-Horn)(  82 unit)
%            Number of literals          :  332 (   0 equality)
%            Number of predicate symbols :   13 (   0 propositional)
%            Number of function symbols  :   30 (  30 constant)
%            Number of variables         :  155 (  27 singleton)
%            Maximal clause size         :   25
%            Maximal term depth          :    1

% Comments : 
%--------------------------------------------------------------------------
input_clause(reflexivity_for_samehouse,axiom,
    [++samehouse(X,X)]).

input_clause(house_1_not_2,axiom,
    [--samehouse(1,2)]).

input_clause(house_1_not_3,axiom,
    [--samehouse(1,3)]).

input_clause(house_1_not_4,axiom,
    [--samehouse(1,4)]).

input_clause(house_1_not_5,axiom,
    [--samehouse(1,5)]).

input_clause(house_2_not_3,axiom,
    [--samehouse(2,3)]).

input_clause(house_2_not_4,axiom,
    [--samehouse(2,4)]).

input_clause(house_2_not_5,axiom,
    [--samehouse(2,5)]).

input_clause(house_3_not_4,axiom,
    [--samehouse(3,4)]).

input_clause(house_3_not_5,axiom,
    [--samehouse(3,5)]).

input_clause(house_4_not_5,axiom,
    [--samehouse(4,5)]).

input_clause(reflexivity_for_sameperson,axiom,
    [++sameperson(X,X)]).

input_clause(englishman_not_italian,axiom,
    [--sameperson(englishman,italian)]).

input_clause(englishman_not_swede,axiom,
    [--sameperson(englishman,swede)]).

input_clause(englishman_not_russian,axiom,
    [--sameperson(englishman,russian)]).

input_clause(englishman_not_american,axiom,
    [--sameperson(englishman,american)]).

input_clause(italian_not_swede,axiom,
    [--sameperson(italian,swede)]).

input_clause(italian_not_russian,axiom,
    [--sameperson(italian,russian)]).

input_clause(italian_not_american,axiom,
    [--sameperson(italian,american)]).

input_clause(swede_not_russian,axiom,
    [--sameperson(swede,russian)]).

input_clause(swede_not_american,axiom,
    [--sameperson(swede,american)]).

input_clause(russian_not_american,axiom,
    [--sameperson(russian,american)]).

input_clause(reflexivity_for_samecolor,axiom,
    [++samecolor(X,X)]).

input_clause(red_not_white,axiom,
    [--samecolor(red,white)]).

input_clause(red_not_green,axiom,
    [--samecolor(red,green)]).

input_clause(red_not_yellow,axiom,
    [--samecolor(red,yellow)]).

input_clause(red_not_blue,axiom,
    [--samecolor(red,blue)]).

input_clause(white_not_green,axiom,
    [--samecolor(white,green)]).

input_clause(white_not_yellow,axiom,
    [--samecolor(white,yellow)]).

input_clause(white_not_blue,axiom,
    [--samecolor(white,blue)]).

input_clause(green_not_yellow,axiom,
    [--samecolor(green,yellow)]).

input_clause(green_not_blue,axiom,
    [--samecolor(green,blue)]).

input_clause(yellow_not_blue,axiom,
    [--samecolor(yellow,blue)]).

input_clause(reflexivity_for_samedrink,axiom,
    [++samedrink(X,X)]).

input_clause(lemonade_not_coffee,axiom,
    [--samedrink(lemonade,coffee)]).

input_clause(lemonade_not_milk,axiom,
    [--samedrink(lemonade,milk)]).

input_clause(lemonade_not_vodka,axiom,
    [--samedrink(lemonade,vodka)]).

input_clause(lemonade_not_unknown,axiom,
    [--samedrink(lemonade,unknown_drink)]).

input_clause(coffee_not_milk,axiom,
    [--samedrink(coffee,milk)]).

input_clause(coffee_not_vodka,axiom,
    [--samedrink(coffee,vodka)]).

input_clause(coffee_not_known,axiom,
    [--samedrink(coffee,unknown_drink)]).

input_clause(milk_not_vodka,axiom,
    [--samedrink(milk,vodka)]).

input_clause(milk_not_unknown,axiom,
    [--samedrink(milk,unknown_drink)]).

input_clause(vodka_not_unknown,axiom,
    [--samedrink(vodka,unknown_drink)]).

input_clause(reflexivity_for_samegame,axiom,
    [++samegame(X,X)]).

input_clause(backgammon_not_recquetball,axiom,
    [--samegame(backgammon,racquetball)]).

input_clause(backgammon_not_quoits,axiom,
    [--samegame(backgammon,quoits)]).

input_clause(backgammon_not_solitaire,axiom,
    [--samegame(backgammon,solitaire)]).

input_clause(backgammon_not_charades,axiom,
    [--samegame(backgammon,charades)]).

input_clause(racquetball_not_quoits,axiom,
    [--samegame(racquetball,quoits)]).

input_clause(racquetball_not_solitaire,axiom,
    [--samegame(racquetball,solitaire)]).

input_clause(racquetball_not_charades,axiom,
    [--samegame(racquetball,charades)]).

input_clause(quoits_not_solitaire,axiom,
    [--samegame(quoits,solitaire)]).

input_clause(quoits_not_charades,axiom,
    [--samegame(quoits,charades)]).

input_clause(solitaire_not_charades,axiom,
    [--samegame(solitaire,charades)]).

input_clause(reflexivity_for_samepet,axiom,
    [++samepet(X,X)]).

input_clause(guppy_not_toad,axiom,
    [--samepet(guppy,toad)]).

input_clause(guppy_not_camel,axiom,
    [--samepet(guppy,camel)]).

input_clause(guppy_not_rat,axiom,
    [--samepet(guppy,rat)]).

input_clause(guppy_is_pet,axiom,
    [--samepet(guppy,no_pet)]).

input_clause(toad_not_camel,axiom,
    [--samepet(toad,camel)]).

input_clause(toad_not_rat,axiom,
    [--samepet(toad,rat)]).

input_clause(toad_is_pet,axiom,
    [--samepet(toad,no_pet)]).

input_clause(camel_not_rat,axiom,
    [--samepet(camel,rat)]).

input_clause(camel_is_pet,axiom,
    [--samepet(camel,no_pet)]).

input_clause(rat_is_pet,axiom,
    [--samepet(rat,no_pet)]).

input_clause(symmetry_of_nextto,axiom,
    [--nextto(X,Y),
     ++nextto(Y,X)]).

input_clause(non_symmetry_of_left,axiom,
    [--left(X,Y),
     --left(Y,X)]).

input_clause(nextto_means_left,axiom,
    [--nextto(X,Y),
     ++left(X,Y),
     ++left(Y,X)]).

input_clause(left_means_nextto,axiom,
    [--left(X,Y),
     ++nextto(X,Y)]).

input_clause(house_not_nextto_itself,axiom,
    [--samehouse(X,Y),
     --nextto(X,Y)]).

input_clause(nothing_left_of_itself,axiom,
    [--left(X,X)]).

input_clause(nothing_nextto_itself,axiom,
    [--nextto(X,X)]).

input_clause(every_house_has_a_national,axiom,
    [++hasperson(X,englishman),
     ++hasperson(X,italian),
     ++hasperson(X,swede),
     ++hasperson(X,russian),
     ++hasperson(X,american)]).

input_clause(every_natioality_is_used,axiom,
    [++hasperson(1,Y),
     ++hasperson(2,Y),
     ++hasperson(3,Y),
     ++hasperson(4,Y),
     ++hasperson(5,Y)]).

input_clause(every_house_has_color,axiom,
    [++hascolor(X,red),
     ++hascolor(X,white),
     ++hascolor(X,green),
     ++hascolor(X,yellow),
     ++hascolor(X,blue)]).

input_clause(every_color_is_used,axiom,
    [++hascolor(1,Y),
     ++hascolor(2,Y),
     ++hascolor(3,Y),
     ++hascolor(4,Y),
     ++hascolor(5,Y)]).

input_clause(every_house_has_a_drink,axiom,
    [++hasdrink(X,lemonade),
     ++hasdrink(X,coffee),
     ++hasdrink(X,milk),
     ++hasdrink(X,vodka),
     ++hasdrink(X,unknown_drink)]).

input_clause(every_drink_is_used,axiom,
    [++hasdrink(1,Y),
     ++hasdrink(2,Y),
     ++hasdrink(3,Y),
     ++hasdrink(4,Y),
     ++hasdrink(5,Y)]).

input_clause(every_house_has_a_game,axiom,
    [++hasgame(X,backgammon),
     ++hasgame(X,racquetball),
     ++hasgame(X,quoits),
     ++hasgame(X,solitaire),
     ++hasgame(X,charades)]).

input_clause(every_game_is_used,axiom,
    [++hasgame(1,Y),
     ++hasgame(2,Y),
     ++hasgame(3,Y),
     ++hasgame(4,Y),
     ++hasgame(5,Y)]).

input_clause(every_house_has_a_pet,axiom,
    [++haspet(X,guppy),
     ++haspet(X,toad),
     ++haspet(X,camel),
     ++haspet(X,rat),
     ++haspet(X,no_pet)]).

input_clause(every_pet_is_used,axiom,
    [++haspet(1,Y),
     ++haspet(2,Y),
     ++haspet(3,Y),
     ++haspet(4,Y),
     ++haspet(5,Y)]).

input_clause(houses_have_unique_colors,axiom,
    [++samehouse(X1,X2),
     --hascolor(X1,Y),
     --hascolor(X2,Y)]).

input_clause(nationals_have_unique_houses,axiom,
    [++samehouse(X1,X2),
     --hasperson(X1,Y),
     --hasperson(X2,Y)]).

input_clause(drinks_have_unique_houses,axiom,
    [++samehouse(X1,X2),
     --hasdrink(X1,Y),
     --hasdrink(X2,Y)]).

input_clause(games_have_unique_houses,axiom,
    [++samehouse(X1,X2),
     --hasgame(X1,Y),
     --hasgame(X2,Y)]).

input_clause(pets_have_unique_houses,axiom,
    [++samehouse(X1,X2),
     --haspet(X1,Y),
     --haspet(X2,Y)]).

input_clause(houses_have_unique_nationals,axiom,
    [++sameperson(X1,X2),
     --hasperson(Y,X1),
     --hasperson(Y,X2)]).

input_clause(colours_are_unique,axiom,
    [++samecolor(X1,X2),
     --hascolor(Y,X1),
     --hascolor(Y,X2)]).

input_clause(houses_have_unique_drinks,axiom,
    [++samedrink(X1,X2),
     --hasdrink(Y,X1),
     --hasdrink(Y,X2)]).

input_clause(houses_have_unique_games,axiom,
    [++samegame(X1,X2),
     --hasgame(Y,X1),
     --hasgame(Y,X2)]).

input_clause(houses_have_unique_pets,axiom,
    [++samepet(X1,X2),
     --haspet(Y,X1),
     --haspet(Y,X2)]).

input_clause(englishman_lives_in_red_house1,hypothesis,
    [--hasperson(X,englishman),
     ++hascolor(X,red)]).

input_clause(englishman_lives_in_red_house2,hypothesis,
    [++hasperson(X,englishman),
     --hascolor(X,red)]).

input_clause(white_house_left_of_green1,hypothesis,
    [--hascolor(X,white),
     --hascolor(Y,green),
     ++left(X,Y)]).

input_clause(white_house_left_of_green2,hypothesis,
    [--hascolor(X,white),
     ++hascolor(Y,green),
     --left(X,Y)]).

input_clause(white_house_left_of_green3,hypothesis,
    [++hascolor(X,white),
     --hascolor(Y,green),
     --left(X,Y)]).

input_clause(italian_has_guppy1,hypothesis,
    [--hasperson(X,italian),
     ++haspet(X,guppy)]).

input_clause(italian_has_guppy2,hypothesis,
    [++hasperson(X,italian),
     --haspet(X,guppy)]).

input_clause(lemonade_in_green_house1,hypothesis,
    [--hasdrink(X,lemonade),
     ++hascolor(X,green)]).

input_clause(lemonade_in_green_house2,hypothesis,
    [++hasdrink(X,lemonade),
     --hascolor(X,green)]).

input_clause(swede_drinks_coffee1,hypothesis,
    [--hasperson(X,swede),
     ++hasdrink(X,coffee)]).

input_clause(swede_drinks_coffee2,hypothesis,
    [++hasperson(X,swede),
     --hasdrink(X,coffee)]).

input_clause(toad_lives_with_backgammon1,hypothesis,
    [--haspet(X,toad),
     ++hasgame(X,backgammon)]).

input_clause(toad_lives_with_backgammon2,hypothesis,
    [++haspet(X,toad),
     --hasgame(X,backgammon)]).

input_clause(racquetball_played_in_yellow_house1,hypothesis,
    [--hasgame(X,racquetball),
     ++hascolor(X,yellow)]).

input_clause(racquetball_played_in_yellow_house2,hypothesis,
    [++hasgame(X,racquetball),
     --hascolor(X,yellow)]).

input_clause(c1,hypothesis,
    [--haspet(X,camel),
     ++samehouse(Y,Z),
     --nextto(X,Y),
     --nextto(X,Z),
     ++hasgame(Y,quoits),
     ++hasgame(Z,quoits)]).

input_clause(c2,hypothesis,
    [--haspet(X,camel),
     --samehouse(1,X),
     --nextto(X,Y),
     ++hasgame(Y,quoits)]).

input_clause(c3,hypothesis,
    [--haspet(X,camel),
     --samehouse(X,5),
     --nextto(X,Y),
     ++hasgame(Y,quoits)]).

input_clause(c4,hypothesis,
    [--haspet(X,camel),
     ++nextto(X,Y),
     --hasgame(Y,quoits)]).

input_clause(c5,hypothesis,
    [++samehouse(Y,Z),
     --nextto(X,Y),
     --nextto(X,Z),
     --hasgame(X,quoits),
     ++haspet(Y,camel),
     ++haspet(Z,camel)]).

input_clause(c6,hypothesis,
    [--samehouse(1,X),
     --nextto(X,Y),
     --hasgame(X,quoits),
     ++haspet(Y,camel)]).

input_clause(c7,hypothesis,
    [--samehouse(X,5),
     --nextto(X,Y),
     --hasgame(X,quoits),
     ++haspet(Y,camel)]).

input_clause(c8,hypothesis,
    [--haspet(X,rat),
     ++samehouse(Y,Z),
     --nextto(X,Y),
     --nextto(X,Z),
     ++hasgame(Y,racquetball),
     ++hasgame(Z,racquetball)]).

input_clause(c9,hypothesis,
    [--haspet(X,rat),
     --nextto(X,Y),
     --samehouse(1,X),
     ++hasgame(Y,racquetball)]).

input_clause(c10,hypothesis,
    [--haspet(X,rat),
     --nextto(X,Y),
     --samehouse(X,5),
     ++hasgame(Y,racquetball)]).

input_clause(c11,hypothesis,
    [--haspet(X,rat),
     ++nextto(X,Y),
     --hasgame(Y,racquetball)]).

input_clause(c12,hypothesis,
    [++samehouse(Y,Z),
     --nextto(X,Y),
     --nextto(X,Z),
     --hasgame(X,racquetball),
     ++haspet(Y,rat),
     ++haspet(Z,rat)]).

input_clause(c13,hypothesis,
    [--nextto(X,Y),
     --samehouse(1,X),
     --hasgame(X,racquetball),
     ++haspet(Y,rat)]).

input_clause(c14,hypothesis,
    [--nextto(X,Y),
     --samehouse(X,5),
     --hasgame(X,racquetball),
     ++haspet(Y,rat)]).

input_clause(c15,hypothesis,
    [--hasgame(X,solitaire),
     ++hasdrink(X,vodka)]).

input_clause(c16,hypothesis,
    [++hasgame(X,solitaire),
     --hasdrink(X,vodka)]).

input_clause(c17,hypothesis,
    [--hasperson(X,american),
     ++hasgame(X,charades)]).

input_clause(c18,hypothesis,
    [++hasperson(X,american),
     --hasgame(X,charades)]).

input_clause(c19,hypothesis,
    [--hasperson(X,russian),
     ++samehouse(Y,Z),
     --nextto(X,Y),
     --nextto(X,Z),
     ++hascolor(Y,blue),
     ++hascolor(Z,blue)]).

input_clause(c20,hypothesis,
    [--hasperson(X,russian),
     --samehouse(1,X),
     --nextto(X,Y),
     ++hascolor(Y,blue)]).

input_clause(c21,hypothesis,
    [--hasperson(X,russian),
     --samehouse(X,5),
     --nextto(X,Y),
     ++hascolor(Y,blue)]).

input_clause(c22,hypothesis,
    [--hasperson(X,russian),
     ++nextto(X,Y),
     --hascolor(Y,blue)]).

input_clause(c23,hypothesis,
    [++samehouse(Y,Z),
     --nextto(X,Y),
     --nextto(X,Z),
     --hascolor(X,blue),
     ++hasperson(Y,russian),
     ++hasperson(Z,russian)]).

input_clause(c24,hypothesis,
    [--nextto(X,Y),
     --hascolor(X,blue),
     --samehouse(1,X),
     ++hasperson(Y,russian)]).

input_clause(c25,hypothesis,
    [--nextto(X,Y),
     --hascolor(X,blue),
     --samehouse(X,5),
     ++hasperson(Y,russian)]).

input_clause(house1_at_left,hypothesis,
    [--left(X,1)]).

input_clause(house5_at_right,hypothesis,
    [--left(5,X)]).

input_clause(house_1_left_of_2,hypothesis,
    [++left(1,2)]).

input_clause(house_2_left_of_3,hypothesis,
    [++left(2,3)]).

input_clause(house_3_left_of_4,hypothesis,
    [++left(3,4)]).

input_clause(house_4_left_of_5,hypothesis,
    [++left(4,5)]).

input_clause(house_1_not_nextto_3,hypothesis,
    [--nextto(1,3)]).

input_clause(house_1_not_nextto_4,hypothesis,
    [--nextto(1,4)]).

input_clause(house_1_not_nextto_5,hypothesis,
    [--nextto(1,5)]).

input_clause(house_2_not_nextto_4,hypothesis,
    [--nextto(2,4)]).

input_clause(house_2_not_nextto_5,hypothesis,
    [--nextto(2,5)]).

input_clause(house_3_not_nextto_5,hypothesis,
    [--nextto(3,5)]).

input_clause(house_3_has_milk,hypothesis,
    [++hasdrink(3,milk)]).

input_clause(house_1_has_russian,hypothesis,
    [++hasperson(1,russian)]).

input_clause(find_out_house_details,theorem,
    [--hasperson(1,X0),
     --hasperson(2,X1),
     --hasperson(3,X2),
     --hasperson(4,X3),
     --hasperson(5,X4),
     --hascolor(1,X5),
     --hascolor(2,X6),
     --hascolor(3,X7),
     --hascolor(4,X8),
     --hascolor(5,X9),
     --hasdrink(1,X10),
     --hasdrink(2,X11),
     --hasdrink(3,X11a),
     --hasdrink(4,X12),
     --hasdrink(5,X13),
     --hasgame(1,X14),
     --hasgame(2,X15),
     --hasgame(3,X16),
     --hasgame(4,X17),
     --hasgame(5,X18),
     --haspet(1,X19),
     --haspet(2,X20),
     --haspet(3,X21),
     --haspet(4,X22),
     --haspet(5,X23)]).
%--------------------------------------------------------------------------
