%--------------------------------------------------------------------------
% File     : PUZ015=Checkers1-1 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Puzzles
% Problem  : Checkerboard and Dominoes : Opposing corners removed
% Version  : 
% English  : There is a checker board whose upper left and lower right 
%            squares have been removed. There is a box of dominoes that 
%            are one square by two squares in size. Can you exactly cover 
%            the checker board with dominoes?

% Refs     : 
% Source   : [ANL]
% Names    : chekndom.ver1.in [ANL]

% Status   : satisfiable
% Syntax   : Number of clauses           :   37 (   0 non-Horn)(  14 unit)
%            Number of literals          :   63 (  41 equality)
%            Number of predicate symbols :    2 (   0 propositional)
%            Number of function symbols  :   16 (  12 constant)
%            Number of variables         :  148 (   0 singleton)
%            Maximal clause size         :    3
%            Maximal term depth          :    3

% Comments : 
%--------------------------------------------------------------------------
%----Include axioms of equality 
include('Axioms/EQU001-0.ax').
%--------------------------------------------------------------------------
input_clause(complement_substitution1,axiom,
    [--equal(A,B),
     ++equal(complement(A),complement(B))]).

input_clause(row_substitution1,axiom,
    [--equal(C,D),
     ++equal(row(C),row(D))]).

input_clause(squares_substitution1,axiom,
    [--equal(E,F),
     ++equal(squares(E,G,H,I,J,K,L,M),squares(F,G,H,I,J,K,L,M))]).

input_clause(squares_substitution2,axiom,
    [--equal(N,O),
     ++equal(squares(P,N,Q,R,S,T,U,V),squares(P,O,Q,R,S,T,U,V))]).

input_clause(squares_substitution,axiom,
    [--equal(W,X),
     ++equal(squares(Y,Z,W,A,B,C,D,E),squares(Y,Z,X,A,B,C,D,E))]).

input_clause(squares_substitution4,axiom,
    [--equal(F,G),
     ++equal(squares(H,I,J,F,K,L,M,N),squares(H,I,J,G,K,L,M,N))]).

input_clause(squares_substitution5,axiom,
    [--equal(O,P),
     ++equal(squares(Q,R,S,T,O,U,V,W),squares(Q,R,S,T,P,U,V,W))]).

input_clause(squares_substitution6,axiom,
    [--equal(X,Y),
     ++equal(squares(Z,A,B,C,D,X,E,F),squares(Z,A,B,C,D,Y,E,F))]).

input_clause(squares_substitution7,axiom,
    [--equal(G,H),
     ++equal(squares(I,J,K,L,M,N,G,O),squares(I,J,K,L,M,N,H,O))]).

input_clause(squares_substitution8,axiom,
    [--equal(P,Q),
     ++equal(squares(R,S,T,U,V,W,X,P),squares(R,S,T,U,V,W,X,Q))]).

input_clause(successor_substitution,axiom,
    [--equal(Y,Z),
     ++equal(successor(Y),successor(Z))]).

input_clause(achievable_substitution1,axiom,
    [--equal(A3,B3),
     --achievable(A3,C3),
     ++achievable(B3,C3)]).

input_clause(achievable_substitution2,axiom,
    [--equal(D3,E3),
     --achievable(F3,D3),
     ++achievable(F3,E3)]).

input_clause(cover_columns_1_and_2,axiom,
    [--achievable(row(X),squares(not_covered,not_covered,
Y3,Y4,Y5,Y6,Y7,Y8)),
     ++achievable(row(X),squares(covered,covered,
Y3,Y4,Y5,Y6,Y7,Y8))]).

input_clause(cover_columns_2_and_3,axiom,
    [--achievable(row(X),squares(Y1,not_covered,not_covered,
Y4,Y5,Y6,Y7,Y8)),
     ++achievable(row(X),squares(Y1,covered,covered,
Y4,Y5,Y6,Y7,Y8))]).

input_clause(cover_columns_3_and_4,axiom,
    [--achievable(row(X),squares(Y1,Y2,not_covered,not_covered,
Y5,Y6,Y7,Y8)),
     ++achievable(row(X),squares(Y1,Y2,covered,covered,
Y5,Y6,Y7,Y8))]).

input_clause(cover_columns_4_and_5,axiom,
    [--achievable(row(X),squares(Y1,Y2,Y3,not_covered,not_covered,
Y6,Y7,Y8)),
     ++achievable(row(X),squares(Y1,Y2,Y3,covered,covered,
Y6,Y7,Y8))]).

input_clause(cover_columns_5_and_6,axiom,
    [--achievable(row(X),squares(Y1,Y2,Y3,Y4,not_covered,
not_covered,Y7,Y8)),
     ++achievable(row(X),squares(Y1,Y2,Y3,Y4,covered,covered,
Y7,Y8))]).

input_clause(cover_columns_6_and_7,axiom,
    [--achievable(row(X),squares(Y1,Y2,Y3,Y4,Y5,not_covered,
not_covered,Y8)),
     ++achievable(row(X),squares(Y1,Y2,Y3,Y4,Y5,covered,covered,
Y8))]).

input_clause(cover_columns_7_and_8,axiom,
    [--achievable(row(X),squares(Y1,Y2,Y3,Y4,Y5,Y6,not_covered,
not_covered)),
     ++achievable(row(X),squares(Y1,Y2,Y3,Y4,Y5,Y6,covered,
covered))]).

input_clause(place_vertical_pieces,axiom,
    [--achievable(row(X),squares(Y1,Y2,Y3,Y4,Y5,Y6,Y7,Y8)),
     ++achievable(row(successor(X)),squares(complement(Y1),
complement(Y2),complement(Y3),complement(Y4),complement(Y5),
complement(Y6),complement(Y7),complement(Y8)))]).

input_clause(successor_of_1_is_2,axiom,
    [++equal(successor(1),2)]).

input_clause(successor_of_2_is_3,axiom,
    [++equal(successor(2),3)]).

input_clause(successor_of_3_is_4,axiom,
    [++equal(successor(3),4)]).

input_clause(successor_of_4_is_5,axiom,
    [++equal(successor(4),5)]).

input_clause(successor_of_5_is_6,axiom,
    [++equal(successor(5),6)]).

input_clause(successor_of_6_is_7,axiom,
    [++equal(successor(6),7)]).

input_clause(successor_of_7_is_8,axiom,
    [++equal(successor(7),8)]).

input_clause(successor_of_8_is_9,axiom,
    [++equal(successor(8),9)]).

input_clause(complement_of_covered_is_not_covered,axiom,
    [++equal(complement(covered),not_covered)]).

input_clause(complement_of_not_covered_is_covered,axiom,
    [++equal(complement(not_covered),covered)]).

input_clause(complement_of_r_is_not_covered,axiom,
    [++equal(complement(removed),not_covered)]).

input_clause(first_row_initially,hypothesis,
    [++achievable(row(1),squares(removed,not_covered,not_covered,
not_covered,not_covered,not_covered,not_covered,not_covered))]).

%----This clause is in the original, but it not sensible or needed 
% input_clause(can_do_anything_to_row_9,hypothesis,
%     [++achievable(row(9),squares(Y1,Y2,Y3,Y4,Y5,Y6,Y7,Y8))]).

input_clause(try_prove_row_8_can_be_covered,theorem,
    [--achievable(row(8),squares(covered,covered,covered,covered,
covered,covered,covered,not_covered))]).
%--------------------------------------------------------------------------
