%--------------------------------------------------------------------------
% File     : PUZ012=Boxes-1 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Puzzles
% Problem  : The Mislabeled Boxes
% Version  : 
% English  : There are three boxes a, b, and c on a table.
%            Each box contains apples or bananas or oranges.
%            No two boxes contain the same thing.
%            Each box has a label that says it contains apples or says 
%            it contains bananas or says it contains oranges.
%            No box contains what it says on its label.
%            The label on box a says "apples".
%            The label on box b says "oranges".
%            The label on box c says "bananas".
%            You pick up box b and it contains apples.
%            What do the other two boxes contain?

% Refs     : Wos L.A., Overbeek R., Lusk E., Boyle J. (1992), Automated
%            Reasoning, 2nd edition, McGraw-Hill.
%          : Wos L. (1988), Automated Reasoning: 33 Basic Research 
%            Problems, Prentice-Hall.
% Source   : [ANL]
% Names    : Boxes-of-fruit [Wos, et al., 1992]
%          : Boxes-of-fruit [Wos, 1988]
%          : boxes.ver1.in [ANL]

% Status   : 
% Syntax   : Number of clauses           :   18 (   2 non-Horn)(  12 unit)
%            Number of literals          :   28 (   0 equality)
%            Number of predicate symbols :    4 (   0 propositional)
%            Number of function symbols  :    6 (   6 constant)
%            Number of variables         :   12 (   0 singleton)
%            Maximal clause size         :    3
%            Maximal term depth          :    1

% Comments : 
%--------------------------------------------------------------------------
input_clause(reflexivity_for_fruits,axiom,
    [++equal_fruits(X,X)]).

input_clause(reflexivity_for_boxes,axiom,
    [++equal_boxes(X,X)]).

input_clause(label_is_wrong,axiom,
    [--label(X,Y),
     --contains(X,Y)]).

input_clause(each_thing_is_in_a_box,axiom,
    [++contains(boxa,X),
     ++contains(boxb,X),
     ++contains(boxc,X)]).

input_clause(each_box_contains_something,axiom,
    [++contains(X,apples),
     ++contains(X,bananas),
     ++contains(X,oranges)]).

input_clause(contains_is_well_defined1,axiom,
    [--contains(X,Y),
     --contains(X,Z),
     ++equal_fruits(Y,Z)]).

input_clause(contains_is_well_defined2,axiom,
    [--contains(X,Y),
     --contains(Z,Y),
     ++equal_boxes(X,Z)]).

input_clause(boxa_not_boxb,axiom,
    [--equal_boxes(boxa,boxb)]).

input_clause(boxb_not_boxc,axiom,
    [--equal_boxes(boxb,boxc)]).

input_clause(boxa_not_boxc,axiom,
    [--equal_boxes(boxa,boxc)]).

input_clause(apples_not_bananas,axiom,
    [--equal_fruits(apples,bananas)]).

input_clause(bananas_not_oranges,axiom,
    [--equal_fruits(bananas,oranges)]).

input_clause(apples_not_oranges,axiom,
    [--equal_fruits(apples,oranges)]).

input_clause(boxa_labelled_apples,hypothesis,
    [++label(boxa,apples)]).

input_clause(boxb_labelled_oranges,hypothesis,
    [++label(boxb,oranges)]).

input_clause(boxc_labelled_bananas,hypothesis,
    [++label(boxc,bananas)]).

input_clause(boxb_contains_apples,hypothesis,
    [++contains(boxb,apples)]).

input_clause(prove_boxa_contains_bananas_and_boxc_oranges,theorem,
    [--contains(boxa,bananas),
     --contains(boxc,oranges)]).
%--------------------------------------------------------------------------
