%--------------------------------------------------------------------------
% File     : PUZ011=Borders1-1 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Puzzles
% Problem  : An ocean that borders on an African and an Asian country
% Version  : 
% English  : There is a database of assertions about various countries and 
%            oceans and their relationships. Find which ocean borders 
%            on African and Asian countries.

% Refs     : Plaisted D.A. (1982), A Simplified Problem Reduction Format, 
%            Artificial Intelligence 18(X), 227-261.
% Source   : [Plaisted, 1982]
% Names    : Problem 5.6 [Plaisted, 1982]

% Status   : 
% Syntax   : Number of clauses           :   27 (   0 non-Horn)(  26 unit)
%            Number of literals          :   31 (   0 equality)
%            Number of predicate symbols :    5 (   0 propositional)
%            Number of function symbols  :   14 (  14 constant)
%            Number of variables         :    3 (   0 singleton)
%            Maximal clause size         :    5
%            Maximal term depth          :    1

% Comments : 
%--------------------------------------------------------------------------
input_clause(atlantic,hypothesis,
    [++ocean(atlantic)]).

input_clause(indian,hypothesis,
    [++ocean(indian)]).

input_clause(atlantic_brazil,hypothesis,
    [++borders(atlantic,brazil)]).

input_clause(atlantic_uruguay,hypothesis,
    [++borders(atlantic,uruguay)]).

input_clause(atlantic_venesuela,hypothesis,
    [++borders(atlantic,venesuela)]).

input_clause(atlantic_zaire,hypothesis,
    [++borders(atlantic,zaire)]).

input_clause(atlantic_nigeria,hypothesis,
    [++borders(atlantic,nigeria)]).

input_clause(atlantic_angola,hypothesis,
    [++borders(atlantic,angola)]).

input_clause(indian_india,hypothesis,
    [++borders(indian,india)]).

input_clause(indian_pakistan,hypothesis,
    [++borders(indian,pakistan)]).

input_clause(indian_iran,hypothesis,
    [++borders(indian,iran)]).

input_clause(indian_somalia,hypothesis,
    [++borders(indian,somalia)]).

input_clause(indian_kenya,hypothesis,
    [++borders(indian,kenya)]).

input_clause(indian_tanzania,hypothesis,
    [++borders(indian,tanzania)]).

input_clause(brazil,hypothesis,
    [++south_american(brazil)]).

input_clause(uruguay,hypothesis,
    [++south_american(uruguay)]).

input_clause(venezuela,hypothesis,
    [++south_american(venesuela)]).

input_clause(zaire,hypothesis,
    [++african(zaire)]).

input_clause(nigeria,hypothesis,
    [++african(nigeria)]).

input_clause(angola,hypothesis,
    [++african(angola)]).

input_clause(somalia,hypothesis,
    [++african(somalia)]).

input_clause(kenya,hypothesis,
    [++african(kenya)]).

input_clause(tanzania,hypothesis,
    [++african(tanzania)]).

input_clause(india,hypothesis,
    [++asian(india)]).

input_clause(pakistan,hypothesis,
    [++asian(pakistan)]).

input_clause(iran,hypothesis,
    [++asian(iran)]).

input_clause(prove_there_is_a_common_ocean,theorem,
    [--ocean(Ocean),
     --borders(Ocean,African),
     --african(African),
     --borders(Ocean,Asian),
     --asian(Asian)]).
%--------------------------------------------------------------------------
