%--------------------------------------------------------------------------
% File     : PUZ010=Zebra-1 : TPTP v1.1.1. Bugfixed v1.0.1.
% Domain   : Puzzle
% Problem  : Who owns the zebra?
% Version  : 
% English  : There are five consecutive houses, each of a different color 
%            and inhabited by men of different nationalities. They each 
%            own a different pet, have a different favorite drink and 
%            drive a different car.
%            1.  The Englishman lives in the red house.
%            2.  The Spaniard owns the dog.
%            3.  Coffee is drunk in the green house.
%            4.  The Ukrainian drinks tea.
%            5.  The green house is immediately to the right of the
%                ivory house.
%            6.  The Porsche driver owns snails.
%            7.  The Masserati is driven by the man who lives in the
%                yellow house.
%            8.  Milk is drunk in the middle house.
%            9.  The Norwegian lives in the first house on the left. 10. 
%            The man who drives a Saab lives in the house next to
%                the man with the fox.
%            11. The Masserati is driven by the man in the house next
%                to the house where the horse is kept.
%            12. The Honda driver drinks orange juice.
%            13. The Japanese drives a Jaguar.
%            14. The Norwegian lives next to the blue house.
%            The problem is: Who owns the Zebra?  Who drinks water?

% Refs     : Sterling L. and Shapiro E. (1986), The Art of Prolog, MIT 
%            Press, Cambridge MA.
%          : Lee S-J. and Plaisted D.A. (1992), Eliminating Duplication 
%            with the Hyper-Linking Strategy, Journal of Automated 
%            Reasoning 9(1), 25-42.
%          : Lee S-J. (1992), Email to Geoff Sutcliffe.
% Source   : [Lee, 1992]
% Names    : 

% Status   : 
% Syntax   : Number of clauses           :  128 (   6 non-Horn)(  59 unit)
%            Number of literals          :  321 (   0 equality)
%            Number of predicate symbols :   13 (   0 propositional)
%            Number of function symbols  :   30 (  30 constant)
%            Number of variables         :   81 (   0 singleton)
%            Maximal clause size         :   25
%            Maximal term depth          :    1

% Comments : 
% Bugfixes : v1.0.1 - Clause ukranian_and_japanese_drink_different, first 
%            literal's sign fixed.
%--------------------------------------------------------------------------
%---- Live in one of the houses 
input_clause(people_live_somewhere,axiom,
    [--person(P),
     ++lives(P,house_1),
     ++lives(P,house_2),
     ++lives(P,house_3),
     ++lives(P,house_4),
     ++lives(P,house_5)]).

%---- uniqueness.
input_clause(english_and_spaniard_live_apart,axiom,
    [--house(H),
     --lives(english,H),
     --lives(spaniard,H)]).

input_clause(english_and_norwegian_live_apart,axiom,
    [--house(H),
     --lives(english,H),
     --lives(norwegian,H)]).

input_clause(english_and_ukranian_live_apart,axiom,
    [--house(H),
     --lives(english,H),
     --lives(ukranian,H)]).

input_clause(english_and_japanese_live_apart,axiom,
    [--house(H),
     --lives(english,H),
     --lives(japanese,H)]).

input_clause(spaniard_and_norwegian_live_apart,axiom,
    [--house(H),
     --lives(spaniard,H),
     --lives(norwegian,H)]).

input_clause(spaniard_and_ukranian_live_apart,axiom,
    [--house(H),
     --lives(spaniard,H),
     --lives(ukranian,H)]).

input_clause(spaniard_and_japanese_live_apart,axiom,
    [--house(H),
     --lives(spaniard,H),
     --lives(japanese,H)]).

input_clause(norwegian_and_ukranian_live_apart,axiom,
    [--house(H),
     --lives(norwegian,H),
     --lives(ukranian,H)]).

input_clause(norwegian_and_japanese_live_apart,axiom,
    [--house(H),
     --lives(norwegian,H),
     --lives(japanese,H)]).

input_clause(ukranian_and_japanese_live_apart,axiom,
    [--house(H),
     --lives(ukranian,H),
     --lives(japanese,H)]).

%---- Drink one of the drinks 
input_clause(drink_something,axiom,
    [--person(P),
     ++drinks(P,orange),
     ++drinks(P,coffee),
     ++drinks(P,tea),
     ++drinks(P,milk),
     ++drinks(P,water)]).

%---- uniqueness.
input_clause(english_and_spaniard_drink_different,axiom,
    [--drink(H),
     --drinks(english,H),
     --drinks(spaniard,H)]).

input_clause(english_and_norwegian_drink_different,axiom,
    [--drink(H),
     --drinks(english,H),
     --drinks(norwegian,H)]).

input_clause(english_and_unkranian_drink_different,axiom,
    [--drink(H),
     --drinks(english,H),
     --drinks(ukranian,H)]).

input_clause(english_and_japanese_drink_different,axiom,
    [--drink(H),
     --drinks(english,H),
     --drinks(japanese,H)]).

input_clause(spaniard_and_norwegian_drink_different,axiom,
    [--drink(H),
     --drinks(spaniard,H),
     --drinks(norwegian,H)]).

input_clause(spaniard_and_ukranian_drink_different,axiom,
    [--drink(H),
     --drinks(spaniard,H),
     --drinks(ukranian,H)]).

input_clause(spaniard_and_japanese_drink_different,axiom,
    [--drink(H),
     --drinks(spaniard,H),
     --drinks(japanese,H)]).

input_clause(norwegian_and_ukranian_drink_different,axiom,
    [--drink(H),
     --drinks(norwegian,H),
     --drinks(ukranian,H)]).

input_clause(norwegian_and_japanese_drink_different,axiom,
    [--drink(H),
     --drinks(norwegian,H),
     --drinks(japanese,H)]).

input_clause(ukranian_and_japanese_drink_different,axiom,
    [--drink(H),
     --drinks(ukranian,H),
     --drinks(japanese,H)]).

%---- Somke some brand 
input_clause(smoke_something,axiom,
    [--person(P),
     ++smokes(P,kools),
     ++smokes(P,chest),
     ++smokes(P,gold),
     ++smokes(P,lucky),
     ++smokes(P,parl)]).

%---- uniqueness.
input_clause(english_and_spaniard_smoke_different,axiom,
    [--cigarette(H),
     --smokes(english,H),
     --smokes(spaniard,H)]).

input_clause(english_and_norwegian_smoke_different,axiom,
    [--cigarette(H),
     --smokes(english,H),
     --smokes(norwegian,H)]).

input_clause(english_and_ukranian_smoke_different,axiom,
    [--cigarette(H),
     --smokes(english,H),
     --smokes(ukranian,H)]).

input_clause(english_and_japanese_smoke_different,axiom,
    [--cigarette(H),
     --smokes(english,H),
     --smokes(japanese,H)]).

input_clause(spaniard_and_norwegian_smoke_different,axiom,
    [--cigarette(H),
     --smokes(spaniard,H),
     --smokes(norwegian,H)]).

input_clause(spaniard_and_ukranian_smoke_different,axiom,
    [--cigarette(H),
     --smokes(spaniard,H),
     --smokes(ukranian,H)]).

input_clause(spaniard_and_japanese_smoke_different,axiom,
    [--cigarette(H),
     --smokes(spaniard,H),
     --smokes(japanese,H)]).

input_clause(norwegian_and_ukranian_smoke_different,axiom,
    [--cigarette(H),
     --smokes(norwegian,H),
     --smokes(ukranian,H)]).

input_clause(norwegian_and_japanese_smoke_different,axiom,
    [--cigarette(H),
     --smokes(norwegian,H),
     --smokes(japanese,H)]).

input_clause(ukranian_and_japanese_smoke_different,axiom,
    [--cigarette(H),
     --smokes(ukranian,H),
     --smokes(japanese,H)]).

%---- Own one of the pets 
input_clause(own_a_pet,axiom,
    [--person(P),
     ++owns(P,dog),
     ++owns(P,snails),
     ++owns(P,horse),
     ++owns(P,fox),
     ++owns(P,zebra)]).

%---- uniqueness.
input_clause(english_and_spaniard_own_different_pets,axiom,
    [--animal(H),
     --owns(english,H),
     --owns(spaniard,H)]).

input_clause(english_and_norwegian_own_different_pets,axiom,
    [--animal(H),
     --owns(english,H),
     --owns(norwegian,H)]).

input_clause(english_and_ukranian_own_different_pets,axiom,
    [--animal(H),
     --owns(english,H),
     --owns(ukranian,H)]).

input_clause(english_and_japanese_own_different_pets,axiom,
    [--animal(H),
     --owns(english,H),
     --owns(japanese,H)]).

input_clause(spaniard_and_norwegian_own_different_pets,axiom,
    [--animal(H),
     --owns(spaniard,H),
     --owns(norwegian,H)]).

input_clause(spaniard_and_ukranian_own_different_pets,axiom,
    [--animal(H),
     --owns(spaniard,H),
     --owns(ukranian,H)]).

input_clause(spaniard_and_japanese_own_different_pets,axiom,
    [--animal(H),
     --owns(spaniard,H),
     --owns(japanese,H)]).

input_clause(norwegian_and_ukranian_own_different_pets,axiom,
    [--animal(H),
     --owns(norwegian,H),
     --owns(ukranian,H)]).

input_clause(norwegian_and_japanese_own_different_pets,axiom,
    [--animal(H),
     --owns(norwegian,H),
     --owns(japanese,H)]).

input_clause(ukranian_and_japanese_own_different_pets,axiom,
    [--animal(H),
     --owns(ukranian,H),
     --owns(japanese,H)]).

%---- Houses are coloured 
input_clause(house_coloured,axiom,
    [--house(H),
     ++is_color(H,red),
     ++is_color(H,yellow),
     ++is_color(H,blue),
     ++is_color(H,green),
     ++is_color(H,ivory)]).

%---- uniqueness.
input_clause(houses_1_and_2_coloured_different,axiom,
    [--color(H),
     --is_color(house_1,H),
     --is_color(house_2,H)]).

input_clause(houses_1_and_3_coloured_different,axiom,
    [--color(H),
     --is_color(house_1,H),
     --is_color(house_3,H)]).

input_clause(houses_1_and_4_coloured_different,axiom,
    [--color(H),
     --is_color(house_1,H),
     --is_color(house_4,H)]).

input_clause(houses_1_and_5_coloured_different,axiom,
    [--color(H),
     --is_color(house_1,H),
     --is_color(house_5,H)]).

input_clause(houses_2_and_3_coloured_different,axiom,
    [--color(H),
     --is_color(house_2,H),
     --is_color(house_3,H)]).

input_clause(houses_2_and_4_coloured_different,axiom,
    [--color(H),
     --is_color(house_2,H),
     --is_color(house_4,H)]).

input_clause(houses_2_and_5_coloured_different,axiom,
    [--color(H),
     --is_color(house_2,H),
     --is_color(house_5,H)]).

input_clause(houses_3_and_4_coloured_different,axiom,
    [--color(H),
     --is_color(house_3,H),
     --is_color(house_4,H)]).

input_clause(houses_3_and_5_coloured_different,axiom,
    [--color(H),
     --is_color(house_3,H),
     --is_color(house_5,H)]).

input_clause(houses_4_and_5_coloured_different,axiom,
    [--color(H),
     --is_color(house_4,H),
     --is_color(house_5,H)]).

%---- These are the people 
input_clause(english,axiom,
    [++person(english)]).

input_clause(spaniard,axiom,
    [++person(spaniard)]).

input_clause(norwegian,axiom,
    [++person(norwegian)]).

input_clause(ukranian,axiom,
    [++person(ukranian)]).

input_clause(japanese,axiom,
    [++person(japanese)]).

%---- These are the house numbers 
input_clause(house_house_1,axiom,
    [++house(house_1)]).

input_clause(house_house_2,axiom,
    [++house(house_2)]).

input_clause(house_house_3,axiom,
    [++house(house_3)]).

input_clause(house_house_4,axiom,
    [++house(house_4)]).

input_clause(house_house_5,axiom,
    [++house(house_5)]).

%---- These are the colours 
input_clause(red,axiom,
    [++color(red)]).

input_clause(green,axiom,
    [++color(green)]).

input_clause(yellow,axiom,
    [++color(yellow)]).

input_clause(ivory,axiom,
    [++color(ivory)]).

input_clause(blue,axiom,
    [++color(blue)]).

%---- These are the cigarettes 
input_clause(parl,axiom,
    [++cigarette(parl)]).

input_clause(lucky,axiom,
    [++cigarette(lucky)]).

input_clause(kools,axiom,
    [++cigarette(kools)]).

input_clause(gold,axiom,
    [++cigarette(gold)]).

input_clause(chest,axiom,
    [++cigarette(chest)]).

%---- These are the drinks 
input_clause(tea,axiom,
    [++drink(tea)]).

input_clause(orange,axiom,
    [++drink(orange)]).

input_clause(water,axiom,
    [++drink(water)]).

input_clause(milk,axiom,
    [++drink(milk)]).

input_clause(coffee,axiom,
    [++drink(coffee)]).

%---- These are the pets 
input_clause(dog,axiom,
    [++animal(dog)]).

input_clause(zebra,axiom,
    [++animal(zebra)]).

input_clause(snails,axiom,
    [++animal(snails)]).

input_clause(horse,axiom,
    [++animal(horse)]).

input_clause(fox,axiom,
    [++animal(fox)]).

%---- Constraints.
%---- the englishman lives in the red house.
input_clause(english_in_red_house,axiom,
    [++is_color(H,red),
     --house(H),
     --lives(english,H)]).

%---- the spaniard owns dog.
input_clause(spaniard_owns_dog,axiom,
    [++owns(spaniard,dog)]).

%---- the norwegian lives in the first house.
input_clause(norwegian_in_house_house_1,axiom,
    [++lives(norwegian,house_1)]).

%---- kools are smoked in the yellow house.
input_clause(kools_in_yellow_house,axiom,
    [++is_color(H,yellow),
     --person(P),
     --smokes(P,kools),
     --house(H),
     --lives(P,H)]).

%---- chesterfields are smoked next to where the fox is kept. 
input_clause(chesterfield_with_fox,axiom,
    [++next_to(Hhouse_1,Hhouse_2),
     --person(Phouse_1),
     --owns(Phouse_1,fox),
     --house(Hhouse_1),
     --lives(Phouse_1,Hhouse_1),
     --person(Phouse_2),
     --smokes(Phouse_2,chest),
     --house(Hhouse_2),
     --lives(Phouse_2,Hhouse_2)]).

%---- the norwegian lives next to the blue house.
input_clause(norwegian_in_blue_house,axiom,
    [++is_color(Hhouse_2,blue),
     --house(Hhouse_1),
     --lives(norwegian,Hhouse_1),
     --house(Hhouse_2),
     --next_to(Hhouse_1,Hhouse_2)]).

%---- the old gold smoker owns snails.
input_clause(gold_with_snails,axiom,
    [++owns(P,snails),
     --person(P),
     --smokes(P,gold)]).

%---- the lucky strike smoker drinks orange juice.
input_clause(lucky_with_orange,axiom,
    [++drinks(P,orange),
     --person(P),
     --smokes(P,lucky)]).

%---- the ukranian drinks tea.
input_clause(ukranian_drinks_tea,axiom,
    [++drinks(ukranian,tea)]).

%---- the japanese smokes parliaments.
input_clause(japanese_smokes_parliments,axiom,
    [++smokes(japanese,parl)]).

%---- the kools smoker lives next to where the horse is kept. 
input_clause(kools_next_to_horse,axiom,
    [++next_to(Hhouse_1,Hhouse_2),
     --person(Phouse_1),
     --smokes(Phouse_1,kools),
     --house(Hhouse_1),
     --lives(Phouse_1,Hhouse_1),
     --person(Phouse_2),
     --owns(Phouse_2,horse),
     --house(Hhouse_2),
     --lives(Phouse_2,Hhouse_2)]).

%---- coffee is drunk in the green house.
input_clause(coffee_in_green_house,axiom,
    [++is_color(H,green),
     --person(P),
     --drinks(P,coffee),
     --house(H),
     --lives(P,H)]).

%---- the green house is to the immediate right of the ivory house. 
input_clause(green_right_of_ivory,axiom,
    [++left_of(Hhouse_2,Hhouse_1),
     --house(Hhouse_1),
     --is_color(Hhouse_1,green),
     --house(Hhouse_2),
     --is_color(Hhouse_2,ivory)]).

%---- milk is drunk in the middle house.
input_clause(milk_in_middle,axiom,
    [++lives(P,house_3),
     --person(P),
     --drinks(P,milk)]).

%---- axioms for next.
input_clause(left_means_next_to,axiom,
    [++next_to(X,Y),
     --left_of(X,Y)]).

input_clause(right_mean_next_to,axiom,
    [++next_to(X,Y),
     --left_of(Y,X)]).

input_clause(next_to_means_left_or_right,axiom,
    [++left_of(X,Y),
     --next_to(X,Y),
     ++left_of(Y,X)]).

input_clause(house_1_left_of_house_2,axiom,
    [++left_of(house_1,house_2)]).

input_clause(house_2_left_of_house_3,axiom,
    [++left_of(house_2,house_3)]).

input_clause(house_3_left_of_house_4,axiom,
    [++left_of(house_3,house_4)]).

input_clause(house_4_left_of_house_5,axiom,
    [++left_of(house_4,house_5)]).

input_clause(house_1_not_left_of_house_1,axiom,
    [--left_of(house_1,house_1)]).

input_clause(house_2_not_left_of_house_1,axiom,
    [--left_of(house_2,house_1)]).

input_clause(house_3_not_left_of_house_1,axiom,
    [--left_of(house_3,house_1)]).

input_clause(house_4_not_left_of_house_1,axiom,
    [--left_of(house_4,house_1)]).

input_clause(house_5_not_left_of_house_1,axiom,
    [--left_of(house_5,house_1)]).

input_clause(house_2_not_left_of_house_2,axiom,
    [--left_of(house_2,house_2)]).

input_clause(house_3_not_left_of_house_2,axiom,
    [--left_of(house_3,house_2)]).

input_clause(house_4_not_left_of_house_2,axiom,
    [--left_of(house_4,house_2)]).

input_clause(house_5_not_left_of_house_2,axiom,
    [--left_of(house_5,house_2)]).

input_clause(house_1_not_left_of_house_3,axiom,
    [--left_of(house_1,house_3)]).

input_clause(house_3_not_left_of_house_3,axiom,
    [--left_of(house_3,house_3)]).

input_clause(house_4_not_left_of_house_3,axiom,
    [--left_of(house_4,house_3)]).

input_clause(house_5_not_left_of_house_3,axiom,
    [--left_of(house_5,house_3)]).

input_clause(house_1_not_left_of_house_4,axiom,
    [--left_of(house_1,house_4)]).

input_clause(house_2_not_left_of_house_4,axiom,
    [--left_of(house_2,house_4)]).

input_clause(house_4_not_left_of_house_4,axiom,
    [--left_of(house_4,house_4)]).

input_clause(house_5_not_left_of_house_4,axiom,
    [--left_of(house_5,house_4)]).

input_clause(house_1_not_left_of_house_5,axiom,
    [--left_of(house_1,house_5)]).

input_clause(house_2_not_left_of_house_5,axiom,
    [--left_of(house_2,house_5)]).

input_clause(house_3_not_left_of_house_5,axiom,
    [--left_of(house_3,house_5)]).

input_clause(house_5_not_left_of_house_5,axiom,
    [--left_of(house_5,house_5)]).

%---- negation of goal.
input_clause(prove_configuration,theorem,
    [--drinks(norwegian,water),
     --drinks(ukranian,tea),
     --drinks(japanese,coffee),
     --drinks(english,milk),
     --drinks(spaniard,orange),
     --owns(norwegian,fox),
     --owns(ukranian,horse),
     --owns(japanese,zebra),
     --owns(english,snails),
     --owns(spaniard,dog),
     --smokes(norwegian,kools),
     --smokes(ukranian,chest),
     --smokes(japanese,parl),
     --smokes(english,gold),
     --smokes(spaniard,lucky),
     --lives(norwegian,house_1),
     --lives(ukranian,house_2),
     --lives(japanese,house_5),
     --lives(english,house_3),
     --lives(spaniard,house_4),
     --is_color(house_1,yellow),
     --is_color(house_2,blue),
     --is_color(house_3,red),
     --is_color(house_4,ivory),
     --is_color(house_5,green)]).
%--------------------------------------------------------------------------
