%--------------------------------------------------------------------------
% File     : PUZ008=MissCann-2 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Puzzles
% Problem  : Missionaries and Cannibals
% Version  : Theorem formulation : Procedural.
% English  : There are 3 missionaries, 3 cannibals, and a boat on the west 
%            bank of a river. All wish to cross, but the boat holds 
%            at most 2 people. If the cannibals ever outnumber the 
%            missionaries on either bank of the river the outnumbered 
%            missionaries will be eaten. Can they all safely cross the 
%            river?  If so, how? (The boat cannot cross empty.)

% Refs     : 
% Source   : [ANL]
% Names    : mission.ver2.in [ANL]

% Status   : 
% Syntax   : Number of clauses           :   32 (   0 non-Horn)(   2 unit)
%            Number of literals          :   62 (   0 equality)
%            Number of predicate symbols :    1 (   0 propositional)
%            Number of function symbols  :   10 (   6 constant)
%            Number of variables         :    0 (   0 singleton)
%            Maximal clause size         :    2
%            Maximal term depth          :    3

% Comments : 
%--------------------------------------------------------------------------
%----Moving cannibals only, west to east 
input_clause(bccc_mmm_to_cc_bmmmc,axiom,
    [--banks(west(m(0),c(3)),east(m(3),c(0)),boatonwest),
     ++banks(west(m(0),c(2)),east(m(3),c(1)),boatoneast)]).

input_clause(bmmmcc_c_to_mmmc_cc,axiom,
    [--banks(west(m(3),c(2)),east(m(0),c(1)),boatonwest),
     ++banks(west(m(3),c(1)),east(m(0),c(2)),boatoneast)]).

input_clause(bcc_mmmc_to_c_mmmcc,axiom,
    [--banks(west(m(0),c(2)),east(m(3),c(1)),boatonwest),
     ++banks(west(m(0),c(1)),east(m(3),c(2)),boatoneast)]).

input_clause(bmmmc_cc_to_mmm_ccc,axiom,
    [--banks(west(m(3),c(1)),east(m(0),c(2)),boatonwest),
     ++banks(west(m(3),c(0)),east(m(0),c(3)),boatoneast)]).

input_clause(bc_mmmcc_to_x_bmmmccc,axiom,
    [--banks(west(m(0),c(1)),east(m(3),c(2)),boatonwest),
     ++banks(west(m(0),c(0)),east(m(3),c(3)),boatoneast)]).

input_clause(bmmmccc_x_to_mmmc_bcc,axiom,
    [--banks(west(m(3),c(3)),east(m(0),c(0)),boatonwest),
     ++banks(west(m(3),c(1)),east(m(0),c(2)),boatoneast)]).

input_clause(bccc_mmm_to_c_bmmmcc,axiom,
    [--banks(west(m(0),c(3)),east(m(3),c(0)),boatonwest),
     ++banks(west(m(0),c(1)),east(m(3),c(2)),boatoneast)]).

input_clause(bmmmcc_c_to_mmm_bccc,axiom,
    [--banks(west(m(3),c(2)),east(m(0),c(1)),boatonwest),
     ++banks(west(m(3),c(0)),east(m(0),c(3)),boatoneast)]).

input_clause(bcc_mmmc_to_x_bmmmccc,axiom,
    [--banks(west(m(0),c(2)),east(m(3),c(1)),boatonwest),
     ++banks(west(m(0),c(0)),east(m(3),c(3)),boatoneast)]).

%----Moving cannibals only, east to west 
input_clause(cc_bmmmc_to_bccc_mmm,axiom,
    [--banks(west(m(0),c(2)),east(m(3),c(1)),boatoneast),
     ++banks(west(m(0),c(3)),east(m(3),c(0)),boatonwest)]).

input_clause(c_bmmmcc_to_bcc_mmmc,axiom,
    [--banks(west(m(0),c(1)),east(m(3),c(2)),boatoneast),
     ++banks(west(m(0),c(2)),east(m(3),c(1)),boatonwest)]).

input_clause(mmm_bccc_to_bmmmc_cc,axiom,
    [--banks(west(m(3),c(0)),east(m(0),c(3)),boatoneast),
     ++banks(west(m(3),c(1)),east(m(0),c(2)),boatonwest)]).

input_clause(mmmcc_bc_to_bmmmccc_x,axiom,
    [--banks(west(m(3),c(2)),east(m(0),c(1)),boatoneast),
     ++banks(west(m(3),c(3)),east(m(0),c(0)),boatonwest)]).

input_clause(mmmc_bcc_to_bmmmcc_c,axiom,
    [--banks(west(m(3),c(1)),east(m(0),c(2)),boatoneast),
     ++banks(west(m(3),c(2)),east(m(0),c(1)),boatonwest)]).

input_clause(c_bmmmcc_to_bccc_mmm,axiom,
    [--banks(west(m(0),c(1)),east(m(3),c(2)),boatoneast),
     ++banks(west(m(0),c(3)),east(m(3),c(0)),boatonwest)]).

input_clause(mmmc_bcc_to_bmmmccc_x,axiom,
    [--banks(west(m(3),c(1)),east(m(0),c(2)),boatoneast),
     ++banks(west(m(3),c(3)),east(m(0),c(0)),boatonwest)]).

input_clause(mmm_bccc_to_bmmmcc_c,axiom,
    [--banks(west(m(3),c(0)),east(m(0),c(3)),boatoneast),
     ++banks(west(m(3),c(2)),east(m(0),c(1)),boatonwest)]).

%----Moving missionaries only, west to east 
input_clause(bmmmcc_c_to_mmcc_bmc,axiom,
    [--banks(west(m(3),c(2)),east(m(0),c(1)),boatonwest),
     ++banks(west(m(2),c(2)),east(m(1),c(1)),boatoneast)]).

input_clause(bmc_mmcc_to_c_bmmmcc,axiom,
    [--banks(west(m(1),c(1)),east(m(2),c(2)),boatonwest),
     ++banks(west(m(0),c(1)),east(m(3),c(2)),boatoneast)]).

input_clause(bmmmc_cc_to_mc_bmmcc,axiom,
    [--banks(west(m(3),c(1)),east(m(0),c(2)),boatonwest),
     ++banks(west(m(1),c(1)),east(m(2),c(2)),boatoneast)]).

input_clause(bmmcc_mc_to_cc_bmmmc,axiom,
    [--banks(west(m(2),c(2)),east(m(1),c(1)),boatonwest),
     ++banks(west(m(0),c(2)),east(m(3),c(1)),boatoneast)]).

%----Moving missionaries only, east to west 
input_clause(c_bmmmcc_to_bmc_mmcc,axiom,
    [--banks(west(m(0),c(1)),east(m(3),c(2)),boatoneast),
     ++banks(west(m(1),c(1)),east(m(2),c(2)),boatonwest)]).

input_clause(mmcc_bmc_to_bmmmcc_c,axiom,
    [--banks(west(m(2),c(2)),east(m(1),c(1)),boatoneast),
     ++banks(west(m(3),c(2)),east(m(0),c(1)),boatonwest)]).

input_clause(cc_bmmmc_to_bmmcc_mc,axiom,
    [--banks(west(m(0),c(2)),east(m(3),c(1)),boatoneast),
     ++banks(west(m(2),c(2)),east(m(1),c(1)),boatonwest)]).

input_clause(mc_bmmcc_to_bmmmc_cc,axiom,
    [--banks(west(m(1),c(1)),east(m(2),c(2)),boatoneast),
     ++banks(west(m(3),c(1)),east(m(0),c(2)),boatonwest)]).

%----Moving a missionary and a cannibal, west to east 
input_clause(bmmmccc_x_to_mmcc_bmc,axiom,
    [--banks(west(m(3),c(3)),east(m(0),c(0)),boatonwest),
     ++banks(west(m(2),c(2)),east(m(1),c(1)),boatoneast)]).

input_clause(bmmcc_mc_to_mc_bmmcc,axiom,
    [--banks(west(m(2),c(2)),east(m(1),c(1)),boatonwest),
     ++banks(west(m(1),c(1)),east(m(2),c(2)),boatoneast)]).

input_clause(bmc_mmcc_to_x_bmmmccc,axiom,
    [--banks(west(m(1),c(1)),east(m(2),c(2)),boatonwest),
     ++banks(west(m(0),c(0)),east(m(3),c(3)),boatoneast)]).

%----Moving a missionary and a cannibal, east to west 
input_clause(mc_bmmcc_to_bmmcc_mc,axiom,
    [--banks(west(m(1),c(1)),east(m(2),c(2)),boatoneast),
     ++banks(west(m(2),c(2)),east(m(1),c(1)),boatonwest)]).

input_clause(mmcc_bmc_to_bmmmccc_x,axiom,
    [--banks(west(m(2),c(2)),east(m(1),c(1)),boatoneast),
     ++banks(west(m(3),c(3)),east(m(0),c(0)),boatonwest)]).

%----The problem to be solved 
input_clause(starting_configuration,hypothesis,
    [++banks(west(m(3),c(3)),east(m(0),c(0)),boatonwest)]).

input_clause(prove_can_get_across,theorem,
    [--banks(west(m(0),c(0)),east(m(3),c(3)),boatoneast)]).
%--------------------------------------------------------------------------
