%--------------------------------------------------------------------------
% File     : PUZ008=MissCann-1 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Puzzles
% Problem  : Missionaries and Cannibals
% Version  : Theorem formulation : Declarative.
% English  : There are 3 missionaries, 3 cannibals, and a boat on the west 
%            bank of a river. All wish to cross, but the boat holds 
%            at most 2 people. If the cannibals ever outnumber the 
%            missionaries on either bank of the river the outnumbered 
%            missionaries will be eaten. Can they all safely cross the 
%            river?  If so, how? (The boat cannot cross empty.)

% Refs     : 
% Source   : [ANL]
% Names    : mission.ver1.in [ANL]

% Status   : 
% Syntax   : Number of clauses           :   16 (   0 non-Horn)(   6 unit)
%            Number of literals          :   26 (   0 equality)
%            Number of predicate symbols :    1 (   0 propositional)
%            Number of function symbols  :    8 (   3 constant)
%            Number of variables         :   57 (  13 singleton)
%            Maximal clause size         :    2
%            Maximal term depth          :    6

% Comments : 
%--------------------------------------------------------------------------
%----Moving cannibals only 
input_clause(cannibal_west_to_east,axiom,
    [--achievable(west(m(X),c(s(Y))),boatonwest,east(m(Z),c(W))),
     ++achievable(west(m(X),c(Y)),boatoneast,east(m(Z),c(s(W))))]).

input_clause(cannibal_east_to_west,axiom,
    [--achievable(west(m(X),c(Y)),boatoneast,east(m(Z),c(s(W)))),
     ++achievable(west(m(X),c(s(Y))),boatonwest,east(m(Z),c(W)))]).

input_clause(two_cannibals_west_to_east,axiom,
    [--achievable(west(m(X),c(s(s(Y)))),boatonwest,east(m(Z),c(W))),
     ++achievable(west(m(X),c(Y)),boatoneast,east(m(Z),c(s(s(W)))))]).

input_clause(two_cannibals_east_to_west,axiom,
    [--achievable(west(m(X),c(Y)),boatoneast,east(m(Z),c(s(s(W))))),
     ++achievable(west(m(X),c(s(s(Y)))),boatonwest,east(m(Z),c(W)))]).

%----Moving missionaries only 
input_clause(missionary_west_to_east,axiom,
    [--achievable(west(m(s(X)),c(Y)),boatonwest,east(m(Z),c(W))),
     ++achievable(west(m(X),c(Y)),boatoneast,east(m(s(Z)),c(W)))]).

input_clause(missionary_east_to_west,axiom,
    [--achievable(west(m(X),c(Y)),boatoneast,east(m(s(Z)),c(W))),
     ++achievable(west(m(s(X)),c(Y)),boatonwest,east(m(Z),c(W)))]).

input_clause(two_missionaries_west_to_east,axiom,
    [--achievable(west(m(s(s(X))),c(Y)),boatonwest,east(m(Z),c(W))),
     ++achievable(west(m(X),c(Y)),boatoneast,east(m(s(s(Z))),c(W)))]).

input_clause(two_missionaries_east_to_west,axiom,
    [--achievable(west(m(X),c(Y)),boatoneast,east(m(s(s(Z))),c(W))),
     ++achievable(west(m(s(s(X))),c(Y)),boatonwest,east(m(Z),c(W)))]).

%----Moving a missionary and a cannibal 
input_clause(missionary_and_cannibal_west_to_east,axiom,
    [--achievable(west(m(s(X)),c(s(Y))),boatonwest,east(m(Z),c(W))),
     ++achievable(west(m(X),c(Y)),boatoneast,east(m(s(Z)),c(s(W))))]).

input_clause(missionary_and_cannibal_east_to_west,axiom,
    [--achievable(west(m(X),c(Y)),boatoneast,east(m(s(Z)),c(s(W)))),
     ++achievable(west(m(s(X)),c(s(Y))),boatonwest,east(m(Z),c(W)))]).

input_clause(extra_cannibal_meal_on_west_bank,axiom,
    [++achievable(west(m(s(X)),c(s(s(X)))),Y,east(Z,W))]).

input_clause(two_extra_cannibals_meal_on_west_bank,axiom,
    [++achievable(west(m(s(X)),c(s(s(s(X))))),Y,east(Z,W))]).

input_clause(extra_cannibal_meal_on_east_bank,axiom,
    [++achievable(west(X,Y),Z,east(m(s(W)),c(s(s(W)))))]).

input_clause(two_extra_cannibals_meal_on_east_bank,axiom,
    [++achievable(west(X,Y),Z,east(m(s(W)),c(s(s(s(W))))))]).

input_clause(start_on_west_bank,hypothesis,
    [++achievable(west(m(s(s(s(0)))),c(s(s(s(0))))),boatonwest,
east(m(0),c(0)))]).

input_clause(prove_can_get_to_east_bank,theorem,
    [--achievable(west(m(0),c(0)),X,east(m(s(s(s(0)))),c(s(s(s(0))))))]).
%--------------------------------------------------------------------------
