%--------------------------------------------------------------------------
% File     : PUZ007=MarsVenus2-1 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Puzzles
% Problem  : Mixed couples on Mars and Venus
% Version  : 
% English  : Here's the situation: human observers in this exclusive club 
%            on Ganymede can't distinguish Martians from Venusians, males 
%            from females, except for the fact that Venusian women and 
%            Martian men always tell the truth and Venusian men and 
%            Martian women always lie.
%            A says "I'm from Mars" B exclaims "That's not true!" A and 
%            B are married; are they a mixed couple?

% Refs     : 
% Source   : [ANL]
% Names    : mars_venus2.in [ANL]

% Status   : 
% Syntax   : Number of clauses           :   41 (   7 non-Horn)(   5 unit)
%            Number of literals          :   94 (  20 equality)
%            Number of predicate symbols :    9 (   0 propositional)
%            Number of function symbols  :    5 (   4 constant)
%            Number of variables         :   48 (   1 singleton)
%            Maximal clause size         :    3
%            Maximal term depth          :    2

% Comments : 
%--------------------------------------------------------------------------
%----Include axioms of equality 
include('Axioms/EQU001-0.ax').
%----Include Mars and Venus axioms 
include('Axioms/PUZ001-0.ax').
%----Include Mars and Venus equality axioms 
include('Axioms/PUZ001-0.eq').
%--------------------------------------------------------------------------
input_clause(a_says_hes_from_mars,hypothesis,
    [++says(a,a_from_mars)]).

input_clause(b_says_a_lies,hypothesis,
    [++says(b,a_has_lied)]).

input_clause(a_from_mars1,hypothesis,
    [--from_mars(a),
     ++a_truth(a_from_mars)]).

input_clause(a_from_mars2,hypothesis,
    [++from_mars(a),
     --a_truth(a_from_mars)]).

input_clause(a_from_mars3,hypothesis,
    [--a_truth(a_from_mars),
     --a_truth(statement_by(b))]).

input_clause(a_states,hypothesis,
    [++equal(statement_by(a),a_from_mars)]).

input_clause(b_states,hypothesis,
    [++equal(statement_by(b),a_has_lied)]).

input_clause(truth_of_bs_statement,hypothesis,
    [++a_truth(a_from_mars),
     ++a_truth(statement_by(b))]).

input_clause(different_sex1,hypothesis,
    [--female(a),
     ++male(b)]).

input_clause(different_sex2,hypothesis,
    [--male(a),
     ++female(b)]).

%----Conclude that they are NOT a mixed couple.
%----Denial of the conclusion: either M(A) & V(B) or V(A) & M(B) 
input_clause(assume_one_from_mars,hypothesis,
    [++from_mars(b),
     ++from_mars(a)]).

input_clause(prove_none_from_venus,theorem,
    [++from_venus(a),
     ++from_venus(b)]).

%----Two clauses deleted due to tautology: M(A) | V(A), V(B) | M(B) 
%--------------------------------------------------------------------------
