%--------------------------------------------------------------------------
% File     : PUZ006=MarsVenus1-1 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Puzzles
% Problem  : Determine sex and race on Mars and Venus
% Version  : 
% English  : Here's the situation: human observers in this exclusive club 
%            on Ganymede can't distinguish Martians from Venusians, males 
%            from females, except for the fact that Venusian women and 
%            Martian men always tell the truth and Venusian men and 
%            Martian women always lie.
%            Ork says "Bog is from Venus."  Bog says "Ork is from Mars." 
%            Ork says "Bog is male."  Bog says "Ork is female." Who's 
%            what?  (sex & race).

% Refs     : 
% Source   : [ANL]
% Names    : mars_venus.in [ANL]

% Status   : 
% Syntax   : Number of clauses           :   42 (   4 non-Horn)(   6 unit)
%            Number of literals          :   95 (  18 equality)
%            Number of predicate symbols :    9 (   0 propositional)
%            Number of function symbols  :    7 (   6 constant)
%            Number of variables         :   48 (   1 singleton)
%            Maximal clause size         :    3
%            Maximal term depth          :    2

% Comments : 
%--------------------------------------------------------------------------
%----Include axioms of equality 
include('Axioms/EQU001-0.ax').
%----Include Mars and Venus axioms 
include('Axioms/PUZ001-0.ax').
%----Include Mars and Venus equality axioms 
include('Axioms/PUZ001-0.eq').
%--------------------------------------------------------------------------
%----Ork says "Bog is from Venus."  Bog says "Ork is from Mars." Ork says 
%----"Bog is male."  Bog says "Ork is female.
input_clause(ork_says_bog_is_from_venus,hypothesis,
    [++says(ork,bog_is_from_venus)]).

input_clause(bog_says_ork_is_from_mar,hypothesis,
    [++says(bog,ork_is_from_mars)]).

input_clause(ork_says_bog_is_male,hypothesis,
    [++says(ork,bog_is_male)]).

input_clause(bog_says_ork_is_female,hypothesis,
    [++says(bog,ork_is_female)]).

input_clause(bog_is_from_venus1,hypothesis,
    [--a_truth(bog_is_from_venus),
     ++from_venus(bog)]).

input_clause(ork_is_from_mars1,hypothesis,
    [--a_truth(ork_is_from_mars),
     ++from_mars(ork)]).

input_clause(bog_is_male1,hypothesis,
    [--a_truth(bog_is_male),
     ++male(bog)]).

input_clause(ork_is_female1,hypothesis,
    [--a_truth(ork_is_female),
     ++female(ork)]).

input_clause(bog_is_from_venus2,hypothesis,
    [--from_venus(bog),
     ++a_truth(bog_is_from_venus)]).

input_clause(ork_is_from_mars2,hypothesis,
    [--from_mars(ork),
     ++a_truth(ork_is_from_mars)]).

input_clause(bog_is_male2,hypothesis,
    [--male(bog),
     ++a_truth(bog_is_male)]).

input_clause(ork_is_female2,hypothesis,
    [--female(ork),
     ++a_truth(ork_is_female)]).

input_clause(prove_bog_is_female,theorem,
    [--female(bog)]).
%--------------------------------------------------------------------------
