%--------------------------------------------------------------------------
% File     : PUZ004=Letters-1 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Puzzles
% Problem  : The Letters Puzzle
% Version  : 
% English  : (1) All the dated letters in this room are written on
%                blue paper.
%            (2) None of them are in black ink, except those that are
%                written in the third person.
%            (3) I have not filed any of them that I can read.
%            (4) None of them, that are written on one sheet, are
%                undated.
%            (5) All of them, that are not crossed, are in black ink.  :
%            (6) All of them, written by Brown, begin with "Dear Sir." :
%            (7) All of them, written on blue paper, are filed.        :
%            (8) None of them,  written on more than one sheet, are
%                crossed.
%            (9) None of them, that begin with "Dear Sir," are written
%                in third person.
%            Find out everything that you can about the letters.

% Refs     : Carroll L. (1986), Lewis Carroll's Symbolic logic : part 
%            I, Elementary, part II, Advanced, C. N. Potter, New York, NY.
% Source   : [ANL]
% Names    : letters.ver1.in [ANL]

% Status   : 
% Syntax   : Number of clauses           :   12 (   1 non-Horn)(   2 unit)
%            Number of literals          :   22 (   0 equality)
%            Number of predicate symbols :   10 (  10 propositional)
%            Number of function symbols  :    0 (   0 constant)
%            Number of variables         :    0 (   0 singleton)
%            Maximal clause size         :    2
%            Maximal term depth          :    0

% Comments : 
%--------------------------------------------------------------------------
input_clause(dated_on_blue_paper,axiom,
    [--dated,++on_blue_paper]).

input_clause(third_person_in_black_ink,axiom,
    [--in_third_person,++in_black_ink]).

input_clause(black_ink_in_third_person,axiom,
    [++in_third_person,--in_black_ink]).

input_clause(not_filed_if_read,axiom,
    [--can_be_read,--filed]).

input_clause(dated_if_on_one_sheet,axiom,
    [--on_one_sheet,++dated]).

input_clause(not_crossed_in_black_ink,axiom,
    [++crossed,++in_black_ink]).

input_clause(brown_starts_with_sir,axiom,
    [--by_brown,++begins_with_dear_sir]).

input_clause(filed_if_on_blue_paper,axiom,
    [--on_blue_paper,++filed]).

input_clause(on_one_sheet_if_crossed,axiom,
    [++on_one_sheet,--crossed]).

input_clause(no_dear_sirs_in_third_person,axiom,
    [--begins_with_dear_sir,--in_third_person]).

input_clause(letter_by_brown,hypothesis,
    [++by_brown]).

input_clause(prove_it_cannot_be_read,theorem,
    [++can_be_read]).
%--------------------------------------------------------------------------
