%--------------------------------------------------------------------------
% File     : PUZ003=Barber-1 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Puzzles
% Problem  : The Barber Puzzle
% Version  : 
% English  : There is a barbers' club that obeys the following three 
%            conditions: (1) If any member has shaved any other 
%            member -- whether himself or another -- then all members have 
%            shaved him, though not necessarily at the same time.
%            (2) Four of the members are named Guido, Lorenzo, Petrucio, 
%            and Cesare.
%            (3) Guido has shaved Cesare.
%            Has Petrucio shaved Lorenzo or not?

% Refs     : 
% Source   : [ANL]
% Names    : barber.ver1.in [ANL]

% Status   : 
% Syntax   : Number of clauses           :    8 (   0 non-Horn)(   6 unit)
%            Number of literals          :   13 (   0 equality)
%            Number of predicate symbols :    2 (   0 propositional)
%            Number of function symbols  :    5 (   5 constant)
%            Number of variables         :    4 (   0 singleton)
%            Maximal clause size         :    4
%            Maximal term depth          :    1

% Comments : 
%--------------------------------------------------------------------------
input_clause(one_shaved_then_all_shaved,axiom,
    [--member(X),
     --member(Y),
     --shaved(X,Y),
     ++shaved(members,X)]).

input_clause(all_shaved_then_one_shaved,axiom,
    [--shaved(members,X),
     --member(Y),
     ++shaved(Y,X)]).

input_clause(guido,hypothesis,
    [++member(guido)]).

input_clause(lorenzo,hypothesis,
    [++member(lorenzo)]).

input_clause(petruchio,hypothesis,
    [++member(petruchio)]).

input_clause(cesare,hypothesis,
    [++member(cesare)]).

input_clause(guido_has_shaved_cesare,hypothesis,
    [++shaved(guido,cesare)]).

input_clause(prove_petruchio_has_shaved_lorenzo,theorem,
    [--shaved(petruchio,lorenzo)]).
%--------------------------------------------------------------------------
