%--------------------------------------------------------------------------
% File     : PUZ002=Animals-1 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Puzzles
% Problem  : The Animals Puzzle
% Version  : 
% English  : 1)  The only animals in this house are cats.
%            2)  Every animal is suitable for a pet, that loves  to
%                gaze at the moon.
%            3)  When I detest an animal, I avoid it.
%            4)  No animals are carnivorous, unless they  prowl  at
%                night.
%            5)  No cat fails to kill mice.
%            6)  No animals ever take to me,  except  what  are  in
%                this house.
%            7)  Kangaroos are not suitable for pets.
%            8)  None but carnivora kill mice.
%            9)  I detest animals that do not take to me.
%            10) Animals that prowl at night always love to gaze at
%                the moon.
%            The problem is to prove that "I always avoid a kan-garoo".

% Refs     : Carroll L. (1986), Lewis Carroll's Symbolic logic : part 
%            I, Elementary, part II, Advanced, C. N. Potter, New York, NY.
% Source   : [ANL]
% Names    : animals.ver1.in [ANL]

% Status   : 
% Syntax   : Number of clauses           :   12 (   1 non-Horn)(   2 unit)
%            Number of literals          :   22 (   0 equality)
%            Number of predicate symbols :   11 (   0 propositional)
%            Number of function symbols  :    1 (   1 constant)
%            Number of variables         :   10 (   0 singleton)
%            Maximal clause size         :    2
%            Maximal term depth          :    1

% Comments : 
%--------------------------------------------------------------------------
input_clause(only_cats_in_house,axiom,
    [--in_house(Cat),
     ++cat(Cat)]).

input_clause(gazers_are_suitable_pets,axiom,
    [--gazer(Gazer),
     ++suitable_pet(Gazer)]).

input_clause(avoid_detested,axiom,
    [--detested(Detested),
     ++avoided(Detested)]).

input_clause(carnivores_are_prowlers,axiom,
    [--carnivore(Carnivore),
     ++prowler(Carnivore)]).

input_clause(cats_are_mice_killers,axiom,
    [--cat(Cat),
     ++mouse_killer(Cat)]).

input_clause(in_house_if_takes_to_me,axiom,
    [--takes_to_me(Taken_animal),
     ++in_house(Taken_animal)]).

input_clause(kangaroos_are_not_pets,axiom,
    [--kangaroo(Kangaroo),
     --suitable_pet(Kangaroo)]).

input_clause(mouse_killers_are_carnivores,axiom,
    [--mouse_killer(Killer),
     ++carnivore(Killer)]).

input_clause(takes_to_me_or_detested,axiom,
    [++takes_to_me(Animal),
     ++detested(Animal)]).

input_clause(prowlers_are_gazers,axiom,
    [--prowler(Prowler),
     ++gazer(Prowler)]).

input_clause(kangaroo_is_a_kangaroo,axiom,
    [++kangaroo(the_kangaroo)]).

input_clause(avoid_kangaroo,theorem,
    [--avoided(the_kangaroo)]).
%--------------------------------------------------------------------------
