%--------------------------------------------------------------------------
% File     : PUZ001=Agatha-2 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Puzzles
% Problem  : Dreadbury Mansion
% Version  : 
% English  : Someone who lives in Dreadbury Mansion killed Aunt Agatha. 
%            Agatha, the butler, and Charles live in Dreadbury Mansion, 
%            and are the only people who live therein. A killer always 
%            hates his victim, and is never richer than his victim. 
%            Charles hates no one that Aunt Agatha hates. Agatha hates 
%            everyone except the butler. The butler hates everyone not 
%            richer than Aunt Agatha. The butler hates everyone Aunt 
%            Agatha hates. No one hates everyone. Agatha is not the 
%            butler. Therefore : Agatha killed herself.

% Refs     : Pelletier F.J. (1986), Seventy-Five Problems for Testing 
%            Automatic Theorem Provers, Journal of Automated Reasoning 
%            2(2), 191-216.
%          : Pelletier F.J. (1988), Errata, Journal of Automated
%            Reasoning 4(2), 235-236.
% Source   : [Pelletier, 1986]
% Names    : Pelletier 55 [Pelletier, 1986]

% Status   : 
% Syntax   : Number of clauses           :   26 (   3 non-Horn)(   9 unit)
%            Number of literals          :   53 (  20 equality)
%            Number of predicate symbols :    5 (   0 propositional)
%            Number of function symbols  :    5 (   4 constant)
%            Number of variables         :   38 (   0 singleton)
%            Maximal clause size         :    4
%            Maximal term depth          :    2

% Comments : Also known as "Who killed Aunt Agatha"
%          : This problem was contributed to [Pelletier, 1986] by Len 
%            Schubert.
%          : Schubert says "I don't know of any other places where 
%            my "Dreadbury Mansion" (or "Aunt Agatha") problem has been 
%            published, besides in Jeff's "75 Problems". I formulated the 
%            problem as an exercise in resolution, paramodulation and 
%            answer extraction for a graduate AI class at the Univ. 
%            of Alberta in 1983."
%          : This problem is incorrect in [Pelletier, 1986] and is
%            corrected in [Pelletier, 1988].
%--------------------------------------------------------------------------
%----Include axioms of equality 
include('Axioms/EQU001-0.ax').
%--------------------------------------------------------------------------
%----Equality substitution axioms for the problem 
input_clause(every_one_but_substitutivity1,axiom,
    [--equal(A,B),
     ++equal(every_one_but(A),every_one_but(B))]).

input_clause(hates_substitutivity1,axiom,
    [--equal(C,D),
     --hates(C,E),
     ++hates(D,E)]).

input_clause(hates_substitutivity2,axiom,
    [--equal(F,G),
     --hates(H,F),
     ++hates(H,G)]).

input_clause(killed_substitutivity1,axiom,
    [--equal(I,J),
     --killed(I,K),
     ++killed(J,K)]).

input_clause(killed_substitutivity2,axiom,
    [--equal(L,M),
     --killed(N,L),
     ++killed(N,M)]).

input_clause(lives_at_dreadsbury_substitutivity1,axiom,
    [--equal(O,P),
     --lives_at_dreadsbury(O),
     ++lives_at_dreadsbury(P)]).

input_clause(richer_substitutivity1,axiom,
    [--equal(Q,R),
     --richer(Q,S),
     ++richer(R,S)]).

input_clause(richer_substitutivity2,axiom,
    [--equal(T,U),
     --richer(V,T),
     ++richer(V,U)]).

%----The axioms of the problem 
input_clause(someone_in_mansion,axiom,
    [++lives_at_dreadsbury(someone)]).

input_clause(someone_killed_agatha,axiom,
    [++killed(someone,aunt_agatha)]).

input_clause(agatha_lives_at_mansion,axiom,
    [++lives_at_dreadsbury(aunt_agatha)]).

input_clause(butler_lives_at_mansion,axiom,
    [++lives_at_dreadsbury(butler)]).

input_clause(charles_lives_at_mansion,axiom,
    [++lives_at_dreadsbury(charles)]).

input_clause(noone_else_lives_at_mansion,axiom,
    [--lives_at_dreadsbury(Person),
     ++equal(Person,aunt_agatha),
     ++equal(Person,butler),
     ++equal(Person,charles)]).

input_clause(killer_hates_victim,axiom,
    [--killed(Killer,Victim),
     ++hates(Killer,Victim)]).

input_clause(killer_poorer_than_victim,axiom,
    [--killed(Killer,Victim),
     --richer(Killer,Victim)]).

input_clause(charles_and_agatha_hate_different_people,axiom,
    [--hates(aunt_agatha,Person),
     --hates(charles,Person)]).

input_clause(agatha_likes_only_butler,axiom,
    [++equal(Person,butler),
     ++hates(aunt_agatha,Person)]).

input_clause(butler_hates_poor_people,axiom,
    [++richer(Person,aunt_agatha),
     ++hates(butler,Person)]).

input_clause(butler_and_agatha_hate_the_same_people,axiom,
    [--hates(aunt_agatha,Person),
     ++hates(butler,Person)]).

input_clause(noone_hates_everyone,axiom,
    [--hates(Person,every_one_but(Person))]).

input_clause(agatha_is_not_the_butler,axiom,
    [--equal(aunt_agatha,butler)]).

input_clause(prove_agatha_killed_herself,theorem,
    [--killed(aunt_agatha,aunt_agatha)]).
%--------------------------------------------------------------------------
