%--------------------------------------------------------------------------
% File     : PUZ001=Agatha-1 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Puzzles
% Problem  : Dreadbury Mansion
% Version  : Theorem formulation : Reduced > Complete.
% English  : Someone who lives in Dreadbury Mansion killed Aunt Agatha. 
%            Agatha, the butler, and Charles live in Dreadbury Mansion, 
%            and are the only people who live therein. A killer always 
%            hates his victim, and is never richer than his victim. 
%            Charles hates no one that Aunt Agatha hates. Agatha hates 
%            everyone except the butler. The butler hates everyone not 
%            richer than Aunt Agatha. The butler hates everyone Aunt 
%            Agatha hates. No one hates everyone. Agatha is not the 
%            butler. Therefore : Agatha killed herself.

% Refs     : Pelletier F.J. (1986), Seventy-Five Problems for Testing 
%            Automatic Theorem Provers, Journal of Automated Reasoning 
%            2(2), 191-216.
%          : Manthey R., Bry F. (1988), SATCHMO: a theorem prover 
%            implemented in Prolog, In Lusk E., Overbeek R. (Eds), 
%            Proceedings of the 9th International Conference on Automated 
%            Deduction (Argonne, IL, 1988), (Lecture Notes in Computer 
%            Science 310), Springer-Verlag, New York, NY, 415-434.
% Source   : [Manthey & Bry, 1988]
% Names    : 

% Status   : 
% Syntax   : Number of clauses           :   12 (   2 non-Horn)(   5 unit)
%            Number of literals          :   21 (   0 equality)
%            Number of predicate symbols :    4 (   0 propositional)
%            Number of function symbols  :    3 (   3 constant)
%            Number of variables         :    8 (   0 singleton)
%            Maximal clause size         :    3
%            Maximal term depth          :    1

% Comments : Modified by Geoff Sutcliffe.
%          : Also known as "Who killed Aunt Agatha"
%--------------------------------------------------------------------------
input_clause(agatha,hypothesis,
    [++lives(agatha)]).

input_clause(butler,hypothesis,
    [++lives(butler)]).

input_clause(charles,hypothesis,
    [++lives(charles)]).

input_clause(poorer_killer,hypothesis,
    [--killed(X,Y),
     --richer(X,Y)]).

input_clause(different_hates,hypothesis,
    [--hates(agatha,X),
     --hates(charles,X)]).

input_clause(no_one_hates_everyone,hypothesis,
    [--hates(X,agatha),
     --hates(X,butler),
     --hates(X,charles)]).

input_clause(agatha_hates_agatha,hypothesis,
    [++hates(agatha,agatha)]).

input_clause(agatha_hates_charles,hypothesis,
    [++hates(agatha,charles)]).

input_clause(killer_hates_victim,hypothesis,
    [--killed(X,Y),
     ++hates(X,Y)]).

input_clause(same_hates,hypothesis,
    [--hates(agatha,X),
     ++hates(butler,X)]).

input_clause(butler_hates_poor,hypothesis,
    [--lives(X),
     ++richer(X,agatha),
     ++hates(butler,X)]).

input_clause(prove_neither_charles_nor_butler_did_it,theorem,
    [++killed(butler,agatha),
     ++killed(charles,agatha)]).
%--------------------------------------------------------------------------
