%--------------------------------------------------------------------------
% File     : PRV009=FIND-1 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Program Verification
% Problem  : A condition from Hoare's FIND program
% Version  : 
% English  : 

% Refs     : Bledsoe W.W. (1977), Non-resolution Theorem Proving, 
%            Artificial Intelligence 9(X), 1-35.
%          : Plaisted D.A. (1982), A Simplified Problem Reduction Format, 
%            Artificial Intelligence 18(X), 227-261.
% Source   : [Plaisted, 1982]
% Names    : Hoares FIND [Bledsoe, 1977]
%          : Problem 5.5 [Plaisted, 1982]

% Status   : 
% Syntax   : Number of clauses           :    9 (   1 non-Horn)(   5 unit)
%            Number of literals          :   20 (   0 equality)
%            Number of predicate symbols :    2 (   0 propositional)
%            Number of function symbols  :    7 (   6 constant)
%            Number of variables         :    8 (   0 singleton)
%            Maximal clause size         :    5
%            Maximal term depth          :    2

% Comments : 
%--------------------------------------------------------------------------
input_clause(clause_1,theorem,
    [++less_or_equal(X,Y),
     ++less(Y,X)]).

input_clause(clause_2,theorem,
    [++less(j,i)]).

input_clause(clause_3,theorem,
    [++less_or_equal(m,p)]).

input_clause(clause_4,theorem,
    [++less_or_equal(p,q)]).

input_clause(clause_5,theorem,
    [++less_or_equal(q,n)]).

input_clause(clause_6,theorem,
    [--less_or_equal(m,X),
     --less(X,i),
     --less(j,Y),
     --less_or_equal(Y,n),
     ++less_or_equal(a(X),a(Y))]).

input_clause(clause_7,theorem,
    [--less_or_equal(m,X),
     --less_or_equal(X,Y),
     --less_or_equal(Y,j),
     ++less_or_equal(a(X),a(Y))]).

input_clause(clause_8,theorem,
    [--less_or_equal(i,X),
     --less_or_equal(X,Y),
     --less_or_equal(Y,n),
     ++less_or_equal(a(X),a(Y))]).

input_clause(clause_9,theorem,
    [--less_or_equal(a(p),a(q))]).
%--------------------------------------------------------------------------
