%--------------------------------------------------------------------------
% File     : PRV008=Unknown-1 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Program Verification
% Problem  : E7
% Version  : 
% English  : 

% Refs     : McCharen J.D., Overbeek R.A., Wos L.A. (1976), Problems and 
%            Experiments for and with Automated Theorem Proving Programs, 
%            IEEE Transactions on Computers C-25(8), 773-782.
% Source   : [SETHEO]
% Names    : E7 [McCharen, et al., 1976]
%          : v7.lop [SETHEO]

% Status   : 
% Syntax   : Number of clauses           :   23 (   2 non-Horn)(   9 unit)
%            Number of literals          :   45 (  21 equality)
%            Number of predicate symbols :    2 (   0 propositional)
%            Number of function symbols  :    6 (   3 constant)
%            Number of variables         :   36 (   0 singleton)
%            Maximal clause size         :    4
%            Maximal term depth          :    3

% Comments : This problem was contributed to [McCharen, et al., 1976] in 
%            private correspondance from G. Ernst. The axioms are 
%            incomplete.
%--------------------------------------------------------------------------
%----Include axioms of equality 
include('Axioms/EQU001-0.ax').
%----Include axioms for this program verification 
include('Axioms/PRV001-0.ax').
include('Axioms/PRV001-0.eq').
%--------------------------------------------------------------------------
input_clause(clause_1,theorem,
    [--less_than(n,l)]).

input_clause(clause_2,theorem,
    [++less_than(one,l)]).

input_clause(clause_3,theorem,
    [++less_than(a(l),a(predecessor(l)))]).

input_clause(clause_4,theorem,
    [++less_than(X,n),
     ++less_than(n,X),
     --less_than(one,n),
     --less_than(a(X),a(predecessor(n)))]).

input_clause(clause_5,theorem,
    [--less_than(one,X),
     --less_than(X,n),
     --less_than(a(X),a(predecessor(X)))]).
%--------------------------------------------------------------------------
