%--------------------------------------------------------------------------
% File     : PRV005=Unknown-1 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Program Verification
% Problem  : E4
% Version  : 
% English  : 

% Refs     : McCharen J.D., Overbeek R.A., Wos L.A. (1976), Problems and 
%            Experiments for and with Automated Theorem Proving Programs, 
%            IEEE Transactions on Computers C-25(8), 773-782.
% Source   : [SETHEO]
% Names    : E4 [McCharen, et al., 1976]
%          : v4.lop [SETHEO]

% Status   : 
% Syntax   : Number of clauses           :   27 (   2 non-Horn)(  12 unit)
%            Number of literals          :   51 (  21 equality)
%            Number of predicate symbols :    2 (   0 propositional)
%            Number of function symbols  :    8 (   5 constant)
%            Number of variables         :   37 (   0 singleton)
%            Maximal clause size         :    4
%            Maximal term depth          :    3

% Comments : This problem was contributed to [McCharen, et al., 1976] in 
%            private correspondance from G. Ernst. The axioms are 
%            incomplete.
%--------------------------------------------------------------------------
%----Include axioms of equality 
include('Axioms/EQU001-0.ax').
%----Include axioms for this program verification 
include('Axioms/PRV001-0.ax').
include('Axioms/PRV001-0.eq').
%--------------------------------------------------------------------------
input_clause(clause_1,theorem,
    [--less_than(n,k)]).

input_clause(clause_2,theorem,
    [--less_than(k,l)]).

input_clause(clause_3,theorem,
    [--less_than(k,i)]).

input_clause(clause_4,theorem,
    [++less_than(l,n)]).

input_clause(clause_5,theorem,
    [++less_than(one,l)]).

input_clause(clause_6,theorem,
    [++less_than(a(k),a(predecessor(l)))]).

input_clause(clause_7,theorem,
    [++less_than(X,l),
     --less_than(X,successor(n)),
     --less_than(a(X),a(k))]).

input_clause(clause_8,theorem,
    [++less_than(X,l),
     ++less_than(n,X),
     --less_than(one,l),
     --less_than(a(X),a(predecessor(l)))]).

input_clause(clause_9,theorem,
    [--less_than(one,X),
     --less_than(X,l),
     --less_than(a(X),a(predecessor(X)))]).
%--------------------------------------------------------------------------
