%--------------------------------------------------------------------------
% File     : PRV004=Unknown-1 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Program Verification
% Problem  : E3
% Version  : 
% English  : 

% Refs     : McCharen J.D., Overbeek R.A., Wos L.A. (1976), Problems and 
%            Experiments for and with Automated Theorem Proving Programs, 
%            IEEE Transactions on Computers C-25(8), 773-782.
% Source   : [SETHEO]
% Names    : E3 [McCharen, et al., 1976]
%          : v3.lop [SETHEO]

% Status   : 
% Syntax   : Number of clauses           :   29 (   2 non-Horn)(  14 unit)
%            Number of literals          :   53 (  21 equality)
%            Number of predicate symbols :    2 (   0 propositional)
%            Number of function symbols  :    9 (   6 constant)
%            Number of variables         :   37 (   0 singleton)
%            Maximal clause size         :    4
%            Maximal term depth          :    3

% Comments : This problem was contributed to [McCharen, et al., 1976] in 
%            private correspondance from G. Ernst. The axioms are 
%            incomplete.
%--------------------------------------------------------------------------
%----Include axioms of equality 
include('Axioms/EQU001-0.ax').
%----Include axioms for this program verification 
include('Axioms/PRV001-0.ax').
include('Axioms/PRV001-0.eq').
%--------------------------------------------------------------------------
input_clause(clause_1,theorem,
    [--less_than(n,j)]).

input_clause(clause_23,theorem,
    [++less_than(k,j)]).

input_clause(clause_4,theorem,
    [--less_than(k,i)]).

input_clause(clause_5,theorem,
    [++less_than(i,n)]).

input_clause(clause_6,theorem,
    [++less_than(a(j),a(k))]).

input_clause(clause_7,theorem,
    [++less_than(a(q),a(k))]).

input_clause(clause_8,theorem,
    [++less_than(X,i),
     --less_than(X,j),
     --less_than(a(X),a(k))]).

input_clause(clause_9,theorem,
    [++less_than(X,i),
     ++less_than(n,X),
     --less_than(one,i),
     --less_than(a(X),a(predecessor(i)))]).

input_clause(clause_10,theorem,
    [--less_than(one,X),
     --less_than(X,i),
     --less_than(a(X),a(predecessor(X)))]).

input_clause(clause_11,theorem,
    [--less_than(q,i)]).

input_clause(clause_12,theorem,
    [--less_than(j,q)]).
%--------------------------------------------------------------------------
