%--------------------------------------------------------------------------
% File     : PRV001=Unknown-1 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Program Verification
% Problem  : PV1
% Version  : 
% English  : These "clauses arose in a natural manner from work done in 
%            program verification" [McCharen, et al., 1976, p. 779].

% Refs     : McCharen J.D., Overbeek R.A., Wos L.A. (1976), Problems and 
%            Experiments for and with Automated Theorem Proving Programs, 
%            IEEE Transactions on Computers C-25(8), 773-782.
% Source   : [McCharen, et al., 1976]
% Names    : PV1 [McCharen, et al., 1976]

% Status   : 
% Syntax   : Number of clauses           :   14 (   2 non-Horn)(   2 unit)
%            Number of literals          :   36 (   4 equality)
%            Number of predicate symbols :    6 (   0 propositional)
%            Number of function symbols  :    3 (   3 constant)
%            Number of variables         :   30 (   2 singleton)
%            Maximal clause size         :    4
%            Maximal term depth          :    1

% Comments : This problem was contributed to [McCharen, et al., 1976] 
%            by E. McCharen. The axioms are incomplete.
%--------------------------------------------------------------------------
input_clause(clause_1,axiom,
    [--q1(X,Y,Z),
     --less_or_equal(X,Y),
     ++q2(X,Y,Z)]).

input_clause(clause_2,axiom,
    [--q1(X,Y,Z),
     ++less_or_equal(X,Y),
     ++q3(X,Y,Z)]).

input_clause(clause_3,axiom,
    [--q2(X,Y,Z),
     ++q4(X,Y,Y)]).

input_clause(clause_4,axiom,
    [--q3(X,Y,Z),
     ++q4(X,Y,X)]).

input_clause(less_or_equal_reflexivity,axiom,
    [++less_or_equal(X,X)]).

input_clause(less_or_equal_implies_equal,axiom,
    [--less_or_equal(X,Y),
     --less_or_equal(Y,X),
     ++equal(X,Y)]).

input_clause(transitivity_of_less_or_equal,axiom,
    [--less_or_equal(X,Y),
     --less_or_equal(Y,Z),
     ++less_or_equal(X,Z)]).

input_clause(all_less_or_equal,axiom,
    [++less_or_equal(X,Y),
     ++less_or_equal(Y,X)]).

input_clause(equal_implies_less_or_equal,axiom,
    [++less_or_equal(X,Y),
     --equal(X,Y)]).

input_clause(less_or_equal_substitution1,axiom,
    [--equal(X,Y),
     --less_or_equal(X,Z),
     ++less_or_equal(Y,Z)]).

input_clause(less_or_equal_substitution2,axiom,
    [--equal(X,Y),
     --less_or_equal(Z,X),
     ++less_or_equal(Z,Y)]).

input_clause(clause_5,theorem,
    [++q1(a,b,c)]).

input_clause(clause_6,theorem,
    [--q4(a,b,W),
     --less_or_equal(a,W),
     --less_or_equal(b,W),
     --less_or_equal(W,a)]).

input_clause(clause_7,theorem,
    [--q4(a,b,W),
     --less_or_equal(a,W),
     --less_or_equal(b,W),
     --less_or_equal(W,b)]).
%--------------------------------------------------------------------------
