%--------------------------------------------------------------------------
% File     : PLA003=Monkey-1 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Planning
% Problem  : Monkey and Bananas Problem
% Version  : 
% English  : 

% Refs     : 
% Source   : [SPRFN]
% Names    : 

% Status   : 
% Syntax   : Number of clauses           :   11 (   0 non-Horn)(   2 unit)
%            Number of literals          :   20 (   0 equality)
%            Number of predicate symbols :    1 (   0 propositional)
%            Number of function symbols  :   11 (   8 constant)
%            Number of variables         :   31 (   7 singleton)
%            Maximal clause size         :    2
%            Maximal term depth          :    2

% Comments : Formulated as a state space.
%--------------------------------------------------------------------------
%----Format of a situation is 
%----(monkey(loc,height,has),ladder(loc,height),bananas(loc,height)) 
%----can(S) means situation S is attainable 

input_clause(climb_up,axiom,
    [++can(monkey(Location1,ceiling,nothing),ladder(Location1,floor),
Bananas),
     --can(monkey(Location1,floor,nothing),ladder(Location1,floor),
Bananas)]).

input_clause(climb_down,axiom,
    [++can(monkey(Location1,floor,nothing),ladder(Location1,floor),
Bananas),
     --can(monkey(Location1,ceiling,nothing),ladder(Location1,floor),
Bananas)]).

input_clause(go_holding_ladder,axiom,
    [++can(monkey(Location2,floor,the_ladder),ladder(Location2,floor),
Bananas),
     --can(monkey(Location1,floor,the_ladder),ladder(Location1,floor),
Bananas)]).

input_clause(go_holding_bananas,axiom,
    [++can(monkey(Location2,floor,the_bananas),Ladder,
bananas(Location2,floor)),
     --can(monkey(Location1,floor,the_bananas),Ladder,
bananas(Location1,floor))]).

input_clause(go_holding_nothing,axiom,
    [++can(monkey(Location2,floor,nothing),Ladder,Bananas),
     --can(monkey(Location1,floor,nothing),Ladder,Bananas)]).

input_clause(drop_ladder,axiom,
    [++can(monkey(Location,Height,nothing),ladder(Location,floor),
Bananas),
     --can(monkey(Location,Height,the_ladder),
ladder(Location,Any_height),Bananas)]).

input_clause(drop_bananas,axiom,
    [++can(monkey(Location,Height,nothing),Ladder,
bananas(Location,floor)),
     --can(monkey(Location,Height,the_bananas),Ladder,
bananas(Location,Height))]).

input_clause(grab_bananas,axiom,
    [++can(monkey(Location,Height,the_bananas),Ladder,
bananas(Location,Height)),
     --can(monkey(Location,Height,nothing),Ladder,
bananas(Location,Height))]).

input_clause(grab_ladder,axiom,
    [++can(monkey(Location,Height,the_ladder),ladder(Location,Height),
Bananas),
     --can(monkey(Location,Height,nothing),ladder(Location,Height),
Bananas)]).

input_clause(initial_situation,hypothesis,
    [++can(monkey(l0,floor,nothing),ladder(l1,floor),
bananas(l2,ceiling))]).

input_clause(prove_the_monkey_can_get_the_bananas,theorem,
    [--can(monkey(_,_,the_bananas),_,_)]).
%--------------------------------------------------------------------------
