%--------------------------------------------------------------------------
% File     : PLA002=Going-2 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Planning
% Problem  : Getting from here to there, in all weather
% Version  : Theorem formulation : Augmented.
% English  : 

% Refs     : Plaisted D.A. (1982), A Simplified Problem Reduction Format, 
%            Artificial Intelligence 18(X), 227-261.
% Source   : [Plaisted, 1982]
% Names    : 

% Status   : 
% Syntax   : Number of clauses           :   23 (   1 non-Horn)(   2 unit)
%            Number of literals          :   64 (   0 equality)
%            Number of predicate symbols :    4 (   0 propositional)
%            Number of function symbols  :   12 (   7 constant)
%            Number of variables         :   27 (   5 singleton)
%            Maximal clause size         :    4
%            Maximal term depth          :    2

% Comments : Includes sort information in the clauses. Inspired by the 
%            problems of building a model if there is no sort info. in the 
%            clauses. In this case the natural interpretation is not a 
%            model of the hypothesiss and hypotheses, as meaningless 
%            (FALSE) instances of clause can be made.
%          : Problem 5.7 in [Plaisted, 1982], modified by Geoff Sutcliffe.
%--------------------------------------------------------------------------
input_clause(warm_or_cold,hypothesis,
    [++warm(Situation1),
     ++cold(Situation2),
     --situation(Situation1),
     --situation(Situation2)]).

input_clause(walk_a_to_b,hypothesis,
    [--at(a,Situation),
     ++at(b,walk(b,Situation)),
     --situation(Situation)]).

input_clause(drive_a_to_b,hypothesis,
    [--at(a,Situation),
     ++at(b,drive(b,Situation)),
     --situation(Situation)]).

input_clause(walk_b_to_a,hypothesis,
    [--at(b,Situation),
     ++at(a,walk(a,Situation)),
     --situation(Situation)]).

input_clause(drive_b_to_a,hypothesis,
    [--at(b,Situation),
     ++at(a,drive(a,Situation)),
     --situation(Situation)]).

input_clause(cross_river_b_to_c,hypothesis,
    [--cold(Situation),
     --at(b,Situation),
     ++at(c,skate(c,Situation)),
     --situation(Situation)]).

input_clause(cross_river_c_to_b,hypothesis,
    [--cold(Situation),
     --at(c,Situation),
     ++at(b,skate(b,Situation)),
     --situation(Situation)]).

input_clause(climb_mountain_b_to_d,hypothesis,
    [--warm(Situation),
     --at(b,Situation),
     ++at(d,climb(d,Situation)),
     --situation(Situation)]).

input_clause(climb_mountain_d_to_b,hypothesis,
    [--warm(Situation),
     --at(d,Situation),
     ++at(b,climb(b,Situation)),
     --situation(Situation)]).

input_clause(go_c_to_d,hypothesis,
    [--at(c,Situation),
     ++at(d,go(d,Situation)),
     --situation(Situation)]).

input_clause(go_d_to_c,hypothesis,
    [--at(d,Situation),
     ++at(c,go(c,Situation)),
     --situation(Situation)]).

input_clause(go_c_to_e,hypothesis,
    [--at(c,Situation),
     ++at(e,go(e,Situation)),
     --situation(Situation)]).

input_clause(go_e_to_c,hypothesis,
    [--at(e,Situation),
     ++at(c,go(c,Situation)),
     --situation(Situation)]).

input_clause(go_d_to_f,hypothesis,
    [--at(d,Situation),
     ++at(f,go(f,Situation)),
     --situation(Situation)]).

input_clause(go_f_to_d,hypothesis,
    [--at(f,Situation),
     ++at(d,go(d,Situation)),
     --situation(Situation)]).

input_clause(initial_situation,hypothesis,
    [++situation(s0)]).

input_clause(walk_situation,hypothesis,
    [--situation(Situation),
     ++situation(walk(Somewhere,Situation))]).

input_clause(drive_situation,hypothesis,
    [--situation(Situation),
     ++situation(drive(Somewhere,Situation))]).

input_clause(climb_situation,hypothesis,
    [--situation(Situation),
     ++situation(climb(Somewhere,Situation))]).

input_clause(skate_situation,hypothesis,
    [--situation(Situation),
     ++situation(skate(Somewhere,Situation))]).

input_clause(go_situation,hypothesis,
    [--situation(Situation),
     ++situation(go(Somewhere,Situation))]).

input_clause(initial,hypothesis,
    [++at(f,s0)]).

input_clause(prove_you_can_get_to_a_in_a_situation,theorem,
    [--at(a,S),
     --situation(S)]).
%--------------------------------------------------------------------------
