%--------------------------------------------------------------------------
% File     : PLA002=Going-1 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Planning
% Problem  : Getting from here to there, in all weather
% Version  : 
% English  : The problem is to travel from one place to another.
%            Certain paths are passable at different times of the year, so 
%            a conditional plan must be generated. Either all situations 
%            are cold or all situations are warm. There is a river which 
%            may be crossed only in winter when it is covered with ice, 
%            and a mountain range may be crossed only in summer. The 
%            problem is to get from city F to city A.

% Refs     : Plaisted D.A. (1982), A Simplified Problem Reduction Format, 
%            Artificial Intelligence 18(X), 227-261.
% Source   : [Plaisted, 1982]
% Names    : Problem 5.7 [Plaisted, 1982]

% Status   : 
% Syntax   : Number of clauses           :   17 (   1 non-Horn)(   2 unit)
%            Number of literals          :   36 (   0 equality)
%            Number of predicate symbols :    3 (   0 propositional)
%            Number of function symbols  :   12 (   7 constant)
%            Number of variables         :   17 (   3 singleton)
%            Maximal clause size         :    3
%            Maximal term depth          :    2

% Comments : 
%--------------------------------------------------------------------------
input_clause(warm_or_cold,hypothesis,
    [++warm(Situation1),
     ++cold(Situation2)]).

input_clause(walk_a_to_b,hypothesis,
    [--at(a,Situation),
     ++at(b,walk(b,Situation))]).

input_clause(drive_a_to_b,hypothesis,
    [--at(a,Situation),
     ++at(b,drive(b,Situation))]).

input_clause(walk_b_to_a,hypothesis,
    [--at(b,Situation),
     ++at(a,walk(a,Situation))]).

input_clause(drive_b_to_a,hypothesis,
    [--at(b,Situation),
     ++at(a,drive(a,Situation))]).

input_clause(cross_river_b_to_c,hypothesis,
    [--cold(Situation),
     --at(b,Situation),
     ++at(c,skate(c,Situation))]).

input_clause(cross_river_c_to_b,hypothesis,
    [--cold(Situation),
     --at(c,Situation),
     ++at(b,skate(b,Situation))]).

input_clause(climb_mountain_b_to_d,hypothesis,
    [--warm(Situation),
     --at(b,Situation),
     ++at(d,climb(d,Situation))]).

input_clause(climb_mountain_d_to_b,hypothesis,
    [--warm(Situation),
     --at(d,Situation),
     ++at(b,climb(b,Situation))]).

input_clause(go_c_to_d,hypothesis,
    [--at(c,Situation),
     ++at(d,go(d,Situation))]).

input_clause(go_d_to_c,hypothesis,
    [--at(d,Situation),
     ++at(c,go(c,Situation))]).

input_clause(go_c_to_e,hypothesis,
    [--at(c,Situation),
     ++at(e,go(e,Situation))]).

input_clause(go_e_to_c,hypothesis,
    [--at(e,Situation),
     ++at(c,go(c,Situation))]).

input_clause(go_d_to_f,hypothesis,
    [--at(d,Situation),
     ++at(f,go(f,Situation))]).

input_clause(go_f_to_d,hypothesis,
    [--at(f,Situation),
     ++at(d,go(d,Situation))]).

input_clause(initial,hypothesis,
    [++at(f,s0)]).

input_clause(prove_you_can_get_to_a,theorem,
    [--at(a,S)]).
%--------------------------------------------------------------------------
