%--------------------------------------------------------------------------
% File     : PLA001=Bread-1 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Planning
% Problem  : Cheyenne to DesMoines, buying a loaf of bread on the way
% Version  : 
% English  : The problem is to drive from Cheyenne, Wyoming to Des Moines, 
%            Iowa and end up there with a loaf of bread. A portion of the 
%            road map is expressed in clause form. The allowable actions 
%            are to drive from a city to a neighboring city, to buy a loaf 
%            of bread at a city, and to wait_at at a city for one unit 
%            of time. Buying a loaf of bread takes one unit of time and 
%            driving to a neighboring city takes two units of time.

% Refs     : Plaisted D.A. (1981), Theory Proving with Abstraction, 
%            Artificial Intelligence 16(X), 47-108.
% Source   : [Plaisted, 1981]
% Names    : 

% Status   : 
% Syntax   : Number of clauses           :   16 (   0 non-Horn)(  12 unit)
%            Number of literals          :   22 (   0 equality)
%            Number of predicate symbols :    2 (   0 propositional)
%            Number of function symbols  :   18 (  14 constant)
%            Number of variables         :   20 (   2 singleton)
%            Maximal clause size         :    3
%            Maximal term depth          :    3

% Comments : 
%--------------------------------------------------------------------------
%----The predicate structures are :
%----    next_to(City,City).
%----The functor structures are :
%----    drive(ToCity,FromSituation).
%----    wait_at(Situation).
%----    buy(Situation).
%--------------------------------------------------------------------------
input_clause(drive1,axiom,
    [--at(FromCity,Loaves,Time,Situation),
     --next_to(FromCity,ToCity),
     ++at(ToCity,Loaves,s(s(Time)),drive(ToCity,Situation))]).

input_clause(drive2,axiom,
    [--at(FromCity,Loaves,Time,Situation),
     --next_to(ToCity,FromCity),
     ++at(ToCity,Loaves,s(s(Time)),drive(ToCity,Situation))]).

input_clause(wait_in_city,axiom,
    [--at(City,Loaves,Time,Situation),
     ++at(City,Loaves,s(Time),wait_at(Situation))]).

input_clause(buy_in_city,axiom,
    [--at(City,Loaves,Time,Situation),
     ++at(City,s(Loaves),s(Time),buy(Situation))]).

input_clause(map1,hypothesis,
    [++next_to(winnemucca,elko)]).

input_clause(map2,hypothesis,
    [++next_to(elko,saltLakeCity)]).

input_clause(map3,hypothesis,
    [++next_to(saltLakeCity,rockSprings)]).

input_clause(map4,hypothesis,
    [++next_to(rockSprings,laramie)]).

input_clause(map5,hypothesis,
    [++next_to(laramie,cheyenne)]).

input_clause(map6,hypothesis,
    [++next_to(cheyenne,northPlatte)]).

input_clause(map7,hypothesis,
    [++next_to(northPlatte,grandIsland)]).

input_clause(map8,hypothesis,
    [++next_to(grandIsland,lincoln)]).

input_clause(map9,hypothesis,
    [++next_to(lincoln,omaha)]).

input_clause(map10,hypothesis,
    [++next_to(omaha,desMoines)]).

input_clause(initial,hypothesis,
    [++at(cheyenne,none,start,initial_situation)]).

input_clause(prove_you_gat_get_there_with_bread,theorem,
    [--at(desMoines,s(none),Time,Situation)]).
%--------------------------------------------------------------------------
