%--------------------------------------------------------------------------
% File     : NUM279=OrdlAddEqn7-2.1 : TPTP v1.1.1. Bugfixed v1.0.1.
% Domain   : Number Theory (Ordinals)
% Problem  : Ordinal addition property 7.1
% Version  : [Quaife, 1992] axioms : Augmented.
% English  : 

% Refs     : Quaife A. (1992), Automated Deduction in von 
%            Neumann-Bernays -Godel Set Theory, In Journal of Automated 
%            Reasoning 8(1), 91-147.
% Source   : [Quaife]
% Names    : OA10 [Quaife]

% Status   : 
% Syntax   : Number of clauses           :  274 (  12 non-Horn)(  55 unit)
%            Number of literals          :  578 ( 255 equality)
%            Number of predicate symbols :   17 (   0 propositional)
%            Number of function symbols  :   63 (  19 constant)
%            Number of variables         :  628 (  43 singleton)
%            Maximal clause size         :    5
%            Maximal term depth          :    6

% Comments : Not in [Quaife, 1992]. Theorem OA9.1 in Quaife's collection.
%          : Quaife proves all these problems by augmenting the axioms 
%            with all previously proved theorems. The user may create 
%            an augmented version of this problem by adding all previously 
%            proved theorems. These include all of Quaife's [1992] set 
%            theory and Boolean algebra theorems, available from the set 
%            theory domain of the TPTP library.
% Bugfixes : v1.0.1 - Bugfix in SET004-1.ax.
%--------------------------------------------------------------------------
%----Include axioms of equality 
include('Axioms/EQU001-0.ax').
%----Include von Neuman-Bernays-Godel set theory axioms 
include('Axioms/SET004-0.ax').
include('Axioms/SET004-0.eq').
%----Include Set theory (Boolean algebra) axioms based on NBG set theory 
include('Axioms/SET004-1.ax').
include('Axioms/SET004-1.eq').
%----Include ordinal number theory axioms.
include('Axioms/NUM004-0.ax').
include('Axioms/NUM004-0.eq').
%--------------------------------------------------------------------------
%----Definition of ordinals_with_null_class_as_identity.
input_clause(ordinals_with_null_class_as_identity1,axiom,
    [++subclass(ordinals_with_null_class_as_identity,ordinal_numbers)]).

input_clause(ordinals_with_null_class_as_identity2,axiom,
    [--member(X,ordinals_with_null_class_as_identity),
     ++equal(ordinal_add(null_class,X),X)]).

input_clause(ordinals_with_null_class_as_identity3,axiom,
    [--member(X,ordinal_numbers),
     --equal(ordinal_add(null_class,X),X),
     ++member(X,ordinals_with_null_class_as_identity)]).

%----These are extra lemmas for this theorem 
input_clause(lemma_1_for_ordinal_addition_property7,axiom,
    [++member(null_class,ordinals_with_null_class_as_identity)]).

input_clause(lemma_2_for_ordinal_addition_property7,axiom,
    [++subclass(image(successor_relation,
ordinals_with_null_class_as_identity),image(successor_relation,
ordinal_numbers))]).

input_clause(lemma_3_for_ordinal_addition_property7,axiom,
    [++subclass(image(successor_relation,
ordinals_with_null_class_as_identity),
ordinals_with_null_class_as_identity)]).

input_clause(lemma_4_for_ordinal_addition_property7,axiom,
    [++subclass(ordinals_with_null_class_as_identity,domain_of(
recursion(null_class,successor_relation,Union_of_range_map)))]).

input_clause(lemma_5_for_ordinal_addition_property7,axiom,
    [++subclass(ordinals_with_null_class_as_identity,domain_of(
intersection(recursion(null_class,successor_relation,Union_of_range_map),
identity_relation)))]).

input_clause(lemma_6_for_ordinal_addition_property7,axiom,
    [++subclass(intersection(power_class(
ordinals_with_null_class_as_identity),limit_ordinals),
ordinals_with_null_class_as_identity)]).

input_clause(prove_ordinal_addition_property7_1_1,theorem,
    [--equal(ordinals_with_null_class_as_identity,ordinal_numbers)]).
%--------------------------------------------------------------------------
