%--------------------------------------------------------------------------
% File     : NUM275=OrdlAddEqn7Lem5-1 : TPTP v1.1.1. Bugfixed v1.0.1.
% Domain   : Number Theory (Ordinals)
% Problem  : Lemma 5 for ordinal addition property 7
% Version  : [Quaife, 1992] axioms.
% English  : 

% Refs     : Quaife A. (1992), Automated Deduction in von 
%            Neumann-Bernays -Godel Set Theory, In Journal of Automated 
%            Reasoning 8(1), 91-147.
% Source   : [Quaife]
% Names    : OA9 lemma 5 [Quaife]

% Status   : 
% Syntax   : Number of clauses           :  268 (  12 non-Horn)(  49 unit)
%            Number of literals          :  572 ( 254 equality)
%            Number of predicate symbols :   17 (   0 propositional)
%            Number of function symbols  :   63 (  19 constant)
%            Number of variables         :  626 (  41 singleton)
%            Maximal clause size         :    5
%            Maximal term depth          :    6

% Comments : Not in [Quaife, 1992]. Theorem OA9 lemma 5 in Quaife's 
%            collection.
%          : Quaife proves all these problems by augmenting the axioms 
%            with all previously proved theorems. The user may create 
%            an augmented version of this problem by adding all previously 
%            proved theorems. These include all of Quaife's [1992] set 
%            theory and Boolean algebra theorems, available from the set 
%            theory domain of the TPTP library.
% Bugfixes : v1.0.1 - Bugfix in SET004-1.ax.
%--------------------------------------------------------------------------
%----Include axioms of equality 
include('Axioms/EQU001-0.ax').
%----Include von Neuman-Bernays-Godel set theory axioms 
include('Axioms/SET004-0.ax').
include('Axioms/SET004-0.eq').
%----Include Set theory (Boolean algebra) axioms based on NBG set theory 
include('Axioms/SET004-1.ax').
include('Axioms/SET004-1.eq').
%----Include ordinal number theory axioms.
include('Axioms/NUM004-0.ax').
include('Axioms/NUM004-0.eq').
%--------------------------------------------------------------------------
%----Definition of ordinals_with_null_class_as_identity.
input_clause(ordinals_with_null_class_as_identity_def1,axiom,
    [++subclass(ordinals_with_null_class_as_identity,ordinal_numbers)]).

input_clause(ordinals_with_null_class_as_identity_def2,axiom,
    [--member(X,ordinals_with_null_class_as_identity),
     ++equal(ordinal_add(null_class,X),X)]).

input_clause(ordinals_with_null_class_as_identity_def3,axiom,
    [--member(X,ordinal_numbers),
     --equal(ordinal_add(null_class,X),X),
     ++member(X,ordinals_with_null_class_as_identity)]).

input_clause(prove_lemma_5_for_ordinal_addition_property7_1,theorem,
    [--subclass(ordinals_with_null_class_as_identity,domain_of(
intersection(recursion(null_class,successor_relation,union_of_range_map),
identity_relation)))]).
%--------------------------------------------------------------------------
