%--------------------------------------------------------------------------
% File     : NUM249=TrnsfRecrEqn5-2 : TPTP v1.1.1. Bugfixed v1.0.1.
% Domain   : Number Theory (Ordinals)
% Problem  : Transfinite recursion property 5
% Version  : [Quaife, 1992] axioms : Augmented.
% English  : 

% Refs     : Quaife A. (1992), Automated Deduction in von 
%            Neumann-Bernays -Godel Set Theory, In Journal of Automated 
%            Reasoning 8(1), 91-147.
% Source   : [Quaife]
% Names    : TREC7-5 [Quaife]

% Status   : 
% Syntax   : Number of clauses           :  281 (  18 non-Horn)(  49 unit)
%            Number of literals          :  632 ( 267 equality)
%            Number of predicate symbols :   17 (   0 propositional)
%            Number of function symbols  :   64 (  19 constant)
%            Number of variables         :  670 (  41 singleton)
%            Maximal clause size         :    6
%            Maximal term depth          :    8

% Comments : Not in [Quaife, 1992]. Theorem TREC7-5 in Quaife's 
%            collection.
%          : Quaife proves all these problems by augmenting the axioms 
%            with all previously proved theorems. The user may create 
%            an augmented version of this problem by adding all previously 
%            proved theorems. These include all of Quaife's [1992] set 
%            theory and Boolean algebra theorems, available from the set 
%            theory domain of the TPTP library.
% Bugfixes : v1.0.1 - Bugfix in SET004-1.ax.
%--------------------------------------------------------------------------
%----Include axioms of equality 
include('Axioms/EQU001-0.ax').
%----Include von Neuman-Bernays-Godel set theory axioms 
include('Axioms/SET004-0.ax').
include('Axioms/SET004-0.eq').
%----Include Set theory (Boolean algebra) axioms based on NBG set theory 
include('Axioms/SET004-1.ax').
include('Axioms/SET004-1.eq').
%----Include ordinal number theory axioms.
include('Axioms/NUM004-0.ax').
include('Axioms/NUM004-0.eq').
%--------------------------------------------------------------------------
%----(TREC.LEMMA0).
input_clause(transfinite_recursion_lemma0,axiom,
    [--member(X,recursion_equation_functions(Z)),
     --member(Y,recursion_equation_functions(Z)),
     ++subclass(domain_of(intersection(complement(Y),X)),ordinal_numbers)]).

%----(TREC.LEMMA1).
input_clause(transfinite_recursion_lemma1,axiom,
    [--member(X,recursion_equation_functions(Z)),
     --member(Y,recursion_equation_functions(Z)),
     --member(ordered_pair(U,V),X),
     --member(U,least(element_relation,domain_of(intersection(
complement(Y),X)))),
     ++member(ordered_pair(U,V),Y)]).

%----(TREC.LEMMA2).
input_clause(transfinite_recursion_lemma2,axiom,
    [--member(X,recursion_equation_functions(Z)),
     --member(Y,recursion_equation_functions(Z)),
     --member(ordered_pair(U,V),Y),
     --member(U,least(element_relation,domain_of(intersection(
complement(Y),X)))),
     ++subclass(X,Y),
     ++member(ordered_pair(U,V),X)]).

%----(TREC.LEMMA3) 
input_clause(transfinite_recursion_lemma3,axiom,
    [--member(X,recursion_equation_functions(Z)),
     --member(Y,recursion_equation_functions(Z)),
     ++subclass(X,Y),
     ++equal(restrict(X,least(element_relation,domain_of(intersection(
complement(Y),X))),universal_class),restrict(Y,least(element_relation,
domain_of(intersection(complement(Y),X))),universal_class))]).

%----(TREC.LEMMA4).
input_clause(transfinite_recursion_lemma4,axiom,
    [--member(X,recursion_equation_functions(Z)),
     --member(Y,recursion_equation_functions(Z)),
     --member(domain_of(X),domain_of(Y)),
     ++subclass(X,Y),
     ++equal(apply(Y,least(element_relation,domain_of(intersection(
complement(Y),X)))),apply(X,least(element_relation,domain_of(
intersection(complement(Y),X)))))]).

%----(TREC.LEMMA5).
input_clause(transfinite_recursion_lemma5,axiom,
    [--member(X,recursion_equation_functions(Z)),
     --member(Y,recursion_equation_functions(Z)),
     --member(domain_of(X),domain_of(Y)),
     ++subclass(X,Y),
     ++member(ordered_pair(least(element_relation,domain_of(intersection(
complement(Y),X))),apply(Y,least(element_relation,domain_of(intersection(
complement(Y),X))))),Y)]).

%----(TREC.LEMMA6).
input_clause(transfinite_recursion_lemma6,axiom,
    [--member(X,recursion_equation_functions(Z)),
     --member(Y,recursion_equation_functions(Z)),
     --member(domain_of(X),domain_of(Y)),
     ++subclass(X,Y)]).

%----corollary.
input_clause(corollary_1_to_transfinite_recursion_lemma6,axiom,
    [--member(X,recursion_equation_functions(Z)),
     --member(Y,recursion_equation_functions(Z)),
     ++member(union(X,Y),recursion_equation_functions(Z))]).

input_clause(corollary_2_to_transfinite_recursion_lemma6,axiom,
    [--member(X,recursion_equation_functions(Z)),
     --member(Y,recursion_equation_functions(Z)),
     ++function(union(X,Y))]).

%----(TREC.LEMMA7).
input_clause(transfinite_recursion_lemma7,axiom,
    [--member(X,recursion_equation_functions(Z)),
     --member(Y,recursion_equation_functions(Z)),
     --member(domain_of(X),domain_of(Y)),
     --member(U,domain_of(X)),
     ++equal(restrict(X,U,universal_class),restrict(Y,U,universal_class))]).

%----(TREC.LEMMA8).
input_clause(transfinite_recursion_lemma8,axiom,
    [--member(X,recursion_equation_functions(Z)),
     --member(Y,recursion_equation_functions(Z)),
     --member(domain_of(X),domain_of(Y)),
     ++subclass(rest_of(X),rest_of(Y))]).

%----(TREC.LEMMA9).
input_clause(transfinite_recursion_lemma9_1,axiom,
    [--member(Z,universal_class),
     ++equal(image(image(composition_function,singleton(Z)),image(
rest_relation,recursion_equation_functions(Z))),
recursion_equation_functions(Z))]).

input_clause(transfinite_recursion_lemma9_2,axiom,
    [++equal(image(comp(Z),image(rest_relation,
recursion_equation_functions(Z))),recursion_equation_functions(Z))]).

%----next not proved.
input_clause(transfinite_recursion_lemma9_3,axiom,
    [--function(X),
     --function(Y),
     --equal(domain_of(X),ordinal_numbers),
     --equal(domain_of(Y),ordinal_numbers),
     ++equal(X,Y),
     ++equal(restrict(X,least(element_relation,domain_of(intersection(
complement(X),Y))),universal_class),restrict(Y,least(element_relation,
domain_of(intersection(complement(X),Y))),universal_class))]).

%----(TREC.LEMMA10).
input_clause(transfinite_recursion_lemma10,axiom,
    [--function(X),
     --equal(compose(Z,rest_of(X)),X),
     --equal(domain_of(X),ordinal_numbers),
     ++subclass(sum_class(recursion_equation_functions(Z)),X),
     ++equal(apply(sum_class(recursion_equation_functions(Z)),least(
element_relation,domain_of(intersection(complement(X),sum_class(
recursion_equation_functions(Z)))))),apply(X,least(element_relation,
domain_of(intersection(complement(X),sum_class(
recursion_equation_functions(Z)))))))]).

%----(TREC.LEMMA11).
input_clause(transfinite_recursion_lemma11,axiom,
    [--function(X),
     --equal(compose(Z,rest_of(X)),X),
     --equal(domain_of(X),ordinal_numbers),
     --member(ordered_pair(least(element_relation,domain_of(intersection(
complement(X),sum_class(recursion_equation_functions(Z))))),apply(
sum_class(recursion_equation_functions(Z)),least(element_relation,
domain_of(intersection(complement(X),sum_class(
recursion_equation_functions(Z))))))),intersection(complement(X),
sum_class(recursion_equation_functions(Z)))),
     ++subclass(sum_class(recursion_equation_functions(Z)),X)]).

input_clause(prove_transfinite_recursion_property5_1,theorem,
    [--equal(compose(z,rest_of(sum_class(
recursion_equation_functions(z)))),sum_class(
recursion_equation_functions(z)))]).
%--------------------------------------------------------------------------
