%--------------------------------------------------------------------------
% File     : NUM240=TrnsfRecrLem9_1-1 : TPTP v1.1.1. Bugfixed v1.0.1.
% Domain   : Number Theory (Ordinals)
% Problem  : Transfinite recursion lemma 9.1
% Version  : [Quaife, 1992] axioms.
% English  : 

% Refs     : Quaife A. (1992), Automated Deduction in von 
%            Neumann-Bernays -Godel Set Theory, In Journal of Automated 
%            Reasoning 8(1), 91-147.
% Source   : [Quaife]
% Names    : TREC.LEMMA9.1 [Quaife]

% Status   : 
% Syntax   : Number of clauses           :  266 (  12 non-Horn)(  49 unit)
%            Number of literals          :  567 ( 253 equality)
%            Number of predicate symbols :   17 (   0 propositional)
%            Number of function symbols  :   64 (  20 constant)
%            Number of variables         :  624 (  41 singleton)
%            Maximal clause size         :    5
%            Maximal term depth          :    6

% Comments : Not in [Quaife, 1992]. Theorem TREC.LEMMA9.1 in Quaife's 
%            collection.
%          : Quaife proves all these problems by augmenting the axioms 
%            with all previously proved theorems. The user may create 
%            an augmented version of this problem by adding all previously 
%            proved theorems. These include all of Quaife's [1992] set 
%            theory and Boolean algebra theorems, available from the set 
%            theory domain of the TPTP library.
% Bugfixes : v1.0.1 - Bugfix in SET004-1.ax.
%--------------------------------------------------------------------------
%----Include axioms of equality 
include('Axioms/EQU001-0.ax').
%----Include von Neuman-Bernays-Godel set theory axioms 
include('Axioms/SET004-0.ax').
include('Axioms/SET004-0.eq').
%----Include Set theory (Boolean algebra) axioms based on NBG set theory 
include('Axioms/SET004-1.ax').
include('Axioms/SET004-1.eq').
%----Include ordinal number theory axioms.
include('Axioms/NUM004-0.ax').
include('Axioms/NUM004-0.eq').
%--------------------------------------------------------------------------
input_clause(prove_transfinite_recursion_lemma9_1_1,theorem,
    [++member(z,universal_class)]).

input_clause(prove_transfinite_recursion_lemma9_1_2,theorem,
    [--equal(image(image(composition_function,singleton(z)),image(
rest,recursion_equation_functions(z))),recursion_equation_functions(z))]).
%--------------------------------------------------------------------------
