%--------------------------------------------------------------------------
% File     : NUM027=Eqn1-1 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Number Theory
% Problem  : If a >= b and b*c <= a*c, then c = 0
% Version  : [Lawrence & Starkey, 1974] axioms :
%            Incomplete > Reduced > Incomplete.
% English  : 

% Refs     : Lawrence J.D., Starkey J.D. (1974), Experimental tests 
%            of resolution based theorem-proving strategies, Technical 
%            Report, Computer Science Department, Washington State 
%            University, Pullman, Washington.
%          : Wilson G.A. and Minker J. (1976), Resolution, Refinements, 
%            and Search Strategies: A Comparative Study, IEEE Transactions 
%            on Computers C-25(8), 782-801.
% Source   : [SPRFN]
% Names    : ls87 [Lawrence & Starkey, 1974]
%          : ls87 [Wilson & Minker, 1976]

% Status   : 
% Syntax   : Number of clauses           :   21 (   2 non-Horn)(  10 unit)
%            Number of literals          :   36 (  23 equality)
%            Number of predicate symbols :    2 (   0 propositional)
%            Number of function symbols  :    8 (   4 constant)
%            Number of variables         :   36 (   3 singleton)
%            Maximal clause size         :    3
%            Maximal term depth          :    4

% Comments : The surplus transitivity axiom is removed.
%--------------------------------------------------------------------------
%----Include Reflexivity, symmetry and transitivity, of equality 
include('Axioms/EQU001-0.ax').
%----Include recursive function + and * axioms 
include('Axioms/NUM001-0.ax').
%----Include recursive function less axioms 
include('Axioms/NUM001-1.ax').
%--------------------------------------------------------------------------
input_clause(equality_preserved_over_times,axiom,
    [--equal(A,B),
     ++equal(multiply(A,C),multiply(B,C))]).

input_clause(not_less_and_equal,axiom,
    [--less(A,B),
     --equal(A,B)]).

input_clause(numbers_either_less_or_equal,axiom,
    [++less(A,B),
     ++equal(B,A),
     ++less(B,A)]).

input_clause(number_not_less_than_itself,axiom,
    [--less(A,A)]).

input_clause(zero_is_the_first_number,axiom,
    [--equal(successor(A),0)]).

input_clause(multiply_lemma,axiom,
    [--less(A,B),
     ++equal(C,0),
     ++less(multiply(A,C),multiply(B,C))]).

input_clause(b_not_less_than_a,hypothesis,
    [--less(b,a)]).

input_clause(b_times_c_less_than_a_times_c,hypothesis,
    [++less(multiply(b,c),multiply(a,c))]).

input_clause(prove_c_is_0,theorem,
    [--equal(c,0)]).
%--------------------------------------------------------------------------
