%--------------------------------------------------------------------------
% File     : NUM025=LtASym-2 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Number Theory
% Problem  : If a<b then not b<a
% Version  : [Lawrence & Starkey, 1974] axioms :
%            Incomplete > Reduced > Incomplete.
% English  : 

% Refs     : Lawrence J.D., Starkey J.D. (1974), Experimental tests 
%            of resolution based theorem-proving strategies, Technical 
%            Report, Computer Science Department, Washington State 
%            University, Pullman, Washington.
% Source   : [TPTP]
% Names    : Problem 76t1 [Lawrence & Starkey, 1974]

% Status   : 
% Syntax   : Number of clauses           :   16 (   2 non-Horn)(   9 unit)
%            Number of literals          :   25 (  17 equality)
%            Number of predicate symbols :    2 (   0 propositional)
%            Number of function symbols  :    7 (   3 constant)
%            Number of variables         :   26 (   3 singleton)
%            Maximal clause size         :    3
%            Maximal term depth          :    4

% Comments : ++less transformed to --greater_or_equal
%          : The surplus transitivity axiom is removed.
%--------------------------------------------------------------------------
%----Include Reflexivity, symmetry and transitivity, of equality 
include('Axioms/EQU001-0.ax').
%----Include recursive function axioms 
include('Axioms/NUM001-0.ax').
%--------------------------------------------------------------------------
%----Include recursive function less axioms 
input_clause(transitivity_of_less,axiom,
    [++greater_or_equal(A,B),
     ++greater_or_equal(C,A),
     --greater_or_equal(C,B)]).

input_clause(smaller_number,axiom,
    [--equal(add(successor(A),B),C),
     --greater_or_equal(B,C)]).

input_clause(less_lemma,axiom,
    [++greater_or_equal(A,B),
     ++equal(add(successor(predecessor_of_1st_minus_2nd(B,A)),A),B)]).

input_clause(zero_is_the_first_number,axiom,
    [--equal(successor(A),0)]).

input_clause(no_number_less_than_itself,axiom,
    [++greater_or_equal(A,A)]).

input_clause(a_less_than_b,hypothesis,
    [--greater_or_equal(a,b)]).

input_clause(prove_b_not_less_than_a,theorem,
    [--greater_or_equal(b,a)]).
%--------------------------------------------------------------------------
