%--------------------------------------------------------------------------
% File     : NUM025=LtASym-1 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Number Theory
% Problem  : If a<b then not b<a
% Version  : [Lawrence & Starkey, 1974] axioms :
%            Incomplete > Reduced > Incomplete.
% English  : 

% Refs     : Lawrence J.D., Starkey J.D. (1974), Experimental tests 
%            of resolution based theorem-proving strategies, Technical 
%            Report, Computer Science Department, Washington State 
%            University, Pullman, Washington.
%          : Wilson G.A. and Minker J. (1976), Resolution, Refinements, 
%            and Search Strategies: A Comparative Study, IEEE Transactions 
%            on Computers C-25(8), 782-801.
% Source   : [SPRFN]
% Names    : ls76t1 [Lawrence & Starkey, 1974]
%          : ls76t1 [Wilson & Minker, 1976]

% Status   : 
% Syntax   : Number of clauses           :   16 (   0 non-Horn)(   9 unit)
%            Number of literals          :   25 (  17 equality)
%            Number of predicate symbols :    2 (   0 propositional)
%            Number of function symbols  :    7 (   3 constant)
%            Number of variables         :   26 (   3 singleton)
%            Maximal clause size         :    3
%            Maximal term depth          :    4

% Comments : 
%--------------------------------------------------------------------------
%----Include Reflexivity, symmetry and transitivity, of equality 
include('Axioms/EQU001-0.ax').
%----Include recursive function + and * axioms 
include('Axioms/NUM001-0.ax').
%----Include recursive function less axioms 
include('Axioms/NUM001-1.ax').
%--------------------------------------------------------------------------
input_clause(zero_is_the_first_number,axiom,
    [--equal(successor(A),0)]).

input_clause(no_number_less_than_itself,axiom,
    [--less(A,A)]).

input_clause(a_less_than_b,hypothesis,
    [++less(a,b)]).

input_clause(prove_b_not_less_than_a,theorem,
    [++less(b,a)]).
%--------------------------------------------------------------------------
