%--------------------------------------------------------------------------
% File     : NUM023=0LtX-1 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Number Theory
% Problem  : Zero is less than all successor numbers
% Version  : [Lawrence & Starkey, 1974] axioms : Incomplete.
% English  : 

% Refs     : Lawrence J.D., Starkey J.D. (1974), Experimental tests 
%            of resolution based theorem-proving strategies, Technical 
%            Report, Computer Science Department, Washington State 
%            University, Pullman, Washington.
%          : Wilson G.A. and Minker J. (1976), Resolution, Refinements, 
%            and Search Strategies: A Comparative Study, IEEE Transactions 
%            on Computers C-25(8), 782-801.
% Source   : [SPRFN]
% Names    : ls68 [Lawrence & Starkey, 1974]
%          : ls68 [Wilson & Minker, 1976]

% Status   : 
% Syntax   : Number of clauses           :   15 (   0 non-Horn)(   8 unit)
%            Number of literals          :   24 (  17 equality)
%            Number of predicate symbols :    2 (   0 propositional)
%            Number of function symbols  :    6 (   2 constant)
%            Number of variables         :   26 (   3 singleton)
%            Maximal clause size         :    3
%            Maximal term depth          :    4

% Comments : Surplus transitivity axiom removed and transitivity of less 
%            included.
%--------------------------------------------------------------------------
%----Include Reflexivity, symmetry and transitivity, of equality 
include('Axioms/EQU001-0.ax').
%----Include recursive function + and * axioms 
include('Axioms/NUM001-0.ax').
%----Include recursive function less axioms 
include('Axioms/NUM001-1.ax').
%--------------------------------------------------------------------------
input_clause(zero_is_first_number,axiom,
    [--equal(successor(A),0)]).

input_clause(numbers_less_than_its_successor,axiom,
    [++less(A,successor(A))]).

input_clause(prove_zero_is_less_than_all_successors,theorem,
    [--less(0,successor(a))]).
%--------------------------------------------------------------------------
