%--------------------------------------------------------------------------
% File     : NUM022=LtDiv-1 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Number Theory
% Problem  : Numerator divisble by smaller denominators
% Version  : [Lawrence & Starkey, 1974] axioms : Incomplete.
% English  : If a numerator is divisible by a denominator, then the 
%            numerator is divisible by numbers smaller than the 
%            denominator.

% Refs     : Lawrence J.D., Starkey J.D. (1974), Experimental tests 
%            of resolution based theorem-proving strategies, Technical 
%            Report, Computer Science Department, Washington State 
%            University, Pullman, Washington.
%          : Wilson G.A. and Minker J. (1976), Resolution, Refinements, 
%            and Search Strategies: A Comparative Study, IEEE Transactions 
%            on Computers C-25(8), 782-801.
% Source   : [SPRFN]
% Names    : ls651 [Lawrence & Starkey, 1974]

% Status   : 
% Syntax   : Number of clauses           :   10 (   1 non-Horn)(   3 unit)
%            Number of literals          :   20 (   7 equality)
%            Number of predicate symbols :    3 (   0 propositional)
%            Number of function symbols  :    6 (   3 constant)
%            Number of variables         :   17 (   1 singleton)
%            Maximal clause size         :    3
%            Maximal term depth          :    4

% Comments : 
%--------------------------------------------------------------------------
%----Include the recursive function less axioms 
include('Axioms/NUM001-1.ax').
%----Include the recursive function divides axioms 
include('Axioms/NUM001-2.ax').
%--------------------------------------------------------------------------
input_clause(transitivity,axiom,
    [--equal(A,B),
     --equal(C,A),
     ++equal(C,B)]).

input_clause(a_less_than_b,hypothesis,
    [++less(a,b)]).

input_clause(b_divides_d,hypothesis,
    [++divides(b,d)]).

input_clause(prove_a_less_than_d,theorem,
    [--less(a,d)]).
%--------------------------------------------------------------------------
