%--------------------------------------------------------------------------
% File     : NUM021=NotDiv-1 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Number Theory
% Problem  : If a <= b < c, then c cannot divide a
% Version  : [Lawrence & Starkey, 1974] axioms : Incomplete.
% English  : 

% Refs     : Lawrence J.D., Starkey J.D. (1974), Experimental tests 
%            of resolution based theorem-proving strategies, Technical 
%            Report, Computer Science Department, Washington State 
%            University, Pullman, Washington.
%          : Wilson G.A. and Minker J. (1976), Resolution, Refinements, 
%            and Search Strategies: A Comparative Study, IEEE Transactions 
%            on Computers C-25(8), 782-801.
% Source   : [SPRFN]
% Names    : ls65 [Lawrence & Starkey, 1974]
%          : ls65 [Wilson & Minker, 1976]

% Status   : 
% Syntax   : Number of clauses           :   19 (   1 non-Horn)(   9 unit)
%            Number of literals          :   32 (  19 equality)
%            Number of predicate symbols :    3 (   0 propositional)
%            Number of function symbols  :    8 (   4 constant)
%            Number of variables         :   31 (   3 singleton)
%            Maximal clause size         :    3
%            Maximal term depth          :    4

% Comments : Surplus transitivity axiom removed.
%--------------------------------------------------------------------------
%----Include Reflexivity, symmetry and transitivity, of equality 
include('Axioms/EQU001-0.ax').
%----Include recursive function + and * axioms 
include('Axioms/NUM001-0.ax').
%----Include recursive function less axioms 
include('Axioms/NUM001-1.ax').
%----Include recursive function divides axioms 
include('Axioms/NUM001-2.ax').
%--------------------------------------------------------------------------
input_clause(b_less_than_c,hypothesis,
    [++less(b,c)]).

input_clause(b_greater_equal_a,hypothesis,
    [--less(b,a)]).

input_clause(impossible_c_divides_a,hypothesis,
    [++divides(c,a)]).

input_clause(prove_a_contradiction,theorem,
    [--equal(successor(A),0)]).
%--------------------------------------------------------------------------
