%--------------------------------------------------------------------------
% File     : NUM020=SuccX-1 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Number Theory
% Problem  : a + 1 = successor(a)
% Version  : [Lawrence & Starkey, 1974] axioms :
%            Incomplete > Reduced > Incomplete.
% English  : 

% Refs     : Lawrence J.D., Starkey J.D. (1974), Experimental tests 
%            of resolution based theorem-proving strategies, Technical 
%            Report, Computer Science Department, Washington State 
%            University, Pullman, Washington.
%          : Wilson G.A. and Minker J. (1976), Resolution, Refinements, 
%            and Search Strategies: A Comparative Study, IEEE Transactions 
%            on Computers C-25(8), 782-801.
% Source   : [SPRFN]
% Names    : ls55 [Lawrence & Starkey, 1974]
%          : ls55 [Wilson & Minker, 1976]

% Status   : 
% Syntax   : Number of clauses           :   12 (   0 non-Horn)(   8 unit)
%            Number of literals          :   17 (  17 equality)
%            Number of predicate symbols :    1 (   0 propositional)
%            Number of function symbols  :    6 (   3 constant)
%            Number of variables         :   17 (   2 singleton)
%            Maximal clause size         :    3
%            Maximal term depth          :    3

% Comments : Surplus transitivity axiom removed.
%--------------------------------------------------------------------------
%----Include Reflexivity, symmetry and transitivity, of equality 
include('Axioms/EQU001-0.ax').
%----Include recursive function + and * axioms 
include('Axioms/NUM001-0.ax').
%--------------------------------------------------------------------------
input_clause(one_succeeds_zero,hypothesis,
    [++equal(1,successor(0))]).

input_clause(deny_addition_lemma,hypothesis,
    [--equal(add(a,successor(0)),successor(a))]).

input_clause(prove_a_contradiction,theorem,
    [--equal(successor(A),0)]).
%--------------------------------------------------------------------------
