%--------------------------------------------------------------------------
% File     : NUM019=EqSymm-1 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Number Theory
% Problem  : Symmetry of equality can be derived
% Version  : [Lawrence & Starkey, 1974] axioms : Incomplete.
% English  : 

% Refs     : Lawrence J.D., Starkey J.D. (1974), Experimental tests 
%            of resolution based theorem-proving strategies, Technical 
%            Report, Computer Science Department, Washington State 
%            University, Pullman, Washington.
%          : Wilson G.A. and Minker J. (1976), Resolution, Refinements, 
%            and Search Strategies: A Comparative Study, IEEE Transactions 
%            on Computers C-25(8), 782-801.
% Source   : [SPRFN]
% Names    : ls41 [Lawrence & Starkey, 1974]
%          : Problem 41 [Lawrence & Starkey, 1974]
%          : ls41 [Wilson & Minker, 1976]

% Status   : 
% Syntax   : Number of clauses           :   11 (   0 non-Horn)(   8 unit)
%            Number of literals          :   15 (  15 equality)
%            Number of predicate symbols :    1 (   0 propositional)
%            Number of function symbols  :    6 (   3 constant)
%            Number of variables         :   15 (   2 singleton)
%            Maximal clause size         :    3
%            Maximal term depth          :    3

% Comments : 
%--------------------------------------------------------------------------
%----Include recursive function + and * axioms 
include('Axioms/NUM001-0.ax').
%--------------------------------------------------------------------------
input_clause(reflexivity,hypothesis,
    [++equal(X,X)]).

input_clause(transitivity,hypothesis,
    [--equal(X,Y),
     --equal(X,Z),
     ++equal(Y,Z)]).

input_clause(zero_is_the_first_number,hypothesis,
    [--equal(successor(A),0)]).

input_clause(a_equals_aa,hypothesis,
    [++equal(a,aa)]).

input_clause(prove_b_equals_a,theorem,
    [--equal(aa,a)]).
%--------------------------------------------------------------------------
