%--------------------------------------------------------------------------
% File     : NUM017=SqRtPrmIrr-2 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Number Theory
% Problem  : Sqaure root of this prime is irrational
% Version  : [Robinson, 1963] axioms : Incomplete > Augmented > Complete.
% English  : If a is prime, and a is not b^2/c^2, then the square root 
%            of a is irrational.

% Refs     : Robinson J.A. (1963), Theorem Proving on the Computer, 
%            Journal of the ACM 10(2), ACM Press, New York, NY, 163-174.
% Source   : [SPRFN]
% Names    : 

% Status   : 
% Syntax   : Number of clauses           :   28 (   0 non-Horn)(   6 unit)
%            Number of literals          :   66 (  22 equality)
%            Number of predicate symbols :    4 (   0 propositional)
%            Number of function symbols  :    7 (   5 constant)
%            Number of variables         :   75 (   1 singleton)
%            Maximal clause size         :    4
%            Maximal term depth          :    2

% Comments : 
%--------------------------------------------------------------------------
%----Include equality axioms 
include('Axioms/EQU001-0.ax').
%--------------------------------------------------------------------------
input_clause(multiply_substitutivity1,axiom,
    [--(equal(A,B)),
     ++(equal(multiply(A,C),multiply(B,C)))]).

input_clause(multiply_substitutivity2,axiom,
    [--(equal(D,E)),
     ++(equal(multiply(F,D),multiply(F,E)))]).

input_clause(second_divided_by_1st_substitutivity1,axiom,
    [--(equal(G,H)),
     ++(equal(second_divided_by_1st(G,I),second_divided_by_1st(H,I)))]).

input_clause(second_divided_by_1st_substitutivity2,axiom,
    [--(equal(J,K)),
     ++(equal(second_divided_by_1st(L,J),second_divided_by_1st(L,K)))]).

input_clause(closure_of_product,axiom,
    [++(product(A,B,multiply(A,B)))]).

input_clause(product_associativity1,axiom,
    [--(product(A,B,C)),
     --(product(D,E,B)),
     --(product(A,D,F)),
     ++(product(F,E,C))]).

input_clause(product_associativity2,axiom,
    [--(product(A,B,C)),
     --(product(D,B,E)),
     --(product(F,D,A)),
     ++(product(F,E,C))]).

input_clause(product_commutativity,axiom,
    [--(product(A,B,C)),
     ++(product(B,A,C))]).

input_clause(product_left_cancellation,axiom,
    [--(product(A,B,C)),
     --(product(A,D,C)),
     ++(equal(B,D))]).

input_clause(transitivity_of_divides,axiom,
    [--(divides(A,B)),
     --(divides(C,A)),
     ++(divides(C,B))]).

input_clause(well_defined_product,axiom,
    [--(product(A,B,C)),
     --(product(A,B,D)),
     ++(equal(D,C))]).

input_clause(product_substitution1,axiom,
    [--(equal(D,B)),
     --(product(C,A,D)),
     ++(product(C,A,B))]).

input_clause(product_substitution2,axiom,
    [--(equal(D,B)),
     --(product(C,D,A)),
     ++(product(C,B,A))]).

input_clause(product_substitution3,axiom,
    [--(equal(C,B)),
     --(product(C,D,A)),
     ++(product(B,D,A))]).

input_clause(divides_substitution1,axiom,
    [--(equal(B,A)),
     --(divides(C,B)),
     ++(divides(C,A))]).

input_clause(divides_substitution2,axiom,
    [--(equal(A,B)),
     --(divides(A,C)),
     ++(divides(B,C))]).

input_clause(prime_substitution,axiom,
    [--(equal(A,B)),
     --(prime(A)),
     ++(prime(B))]).

input_clause(divides_implies_product,axiom,
    [--(divides(A,B)),
     ++(product(A,second_divided_by_1st(A,B),B))]).

input_clause(product_divisible_by_operand,axiom,
    [--(product(A,B,C)),
     ++(divides(A,C))]).

input_clause(primes_lemma1,axiom,
    [--(divides(A,B)),
     --(product(C,C,B)),
     --(prime(A)),
     ++(divides(A,C))]).

input_clause(a_is_prime,hypothesis,
    [++(prime(a))]).

input_clause(b_squared,hypothesis,
    [++(product(b,b,d))]).

input_clause(c_squared,hypothesis,
    [++(product(c,c,e))]).

input_clause(a_times_c_squared_is_not_b_squared,hypothesis,
    [--(product(a,e,d))]).

input_clause(prove_there_is_no_common_divisor,theorem,
    [--(divides(A,c)),
     --(divides(A,b))]).
%--------------------------------------------------------------------------
